/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public final class SnapshotDescriptionUtils {
    private static final Log LOG = LogFactory.getLog(SnapshotDescriptionUtils.class);
    public static final int SNAPSHOT_LAYOUT_VERSION = 2;
    public static final String SNAPSHOTINFO_FILE = ".snapshotinfo";
    public static final String SNAPSHOT_TMP_DIR_NAME = ".tmp";
    public static final String SNAPSHOT_WORKING_DIR = "hbase.snapshot.working.dir";
    public static final long NO_SNAPSHOT_START_TIME_SPECIFIED = 0L;
    public static final String MASTER_SNAPSHOT_TIMEOUT_MILLIS = "hbase.snapshot.master.timeout.millis";
    public static final long DEFAULT_MAX_WAIT_TIME = 300000L;
    @Deprecated
    public static final int SNAPSHOT_TIMEOUT_MILLIS_DEFAULT = 300000;
    @Deprecated
    public static final String SNAPSHOT_TIMEOUT_MILLIS_KEY = "hbase.snapshot.master.timeoutMillis";

    private SnapshotDescriptionUtils() {
    }

    public static long getMaxMasterTimeout(Configuration conf, HBaseProtos.SnapshotDescription.Type type, long defaultMaxWaitTime) {
        switch (type) {
            default: 
        }
        String confKey = MASTER_SNAPSHOT_TIMEOUT_MILLIS;
        return Math.max(conf.getLong(confKey, defaultMaxWaitTime), conf.getLong(SNAPSHOT_TIMEOUT_MILLIS_KEY, defaultMaxWaitTime));
    }

    public static Path getSnapshotRootDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static Path getCompletedSnapshotDir(HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot.getName(), rootDir);
    }

    public static Path getCompletedSnapshotDir(String snapshotName, Path rootDir) {
        return SnapshotDescriptionUtils.getSpecifiedSnapshotDir(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), snapshotName);
    }

    public static Path getWorkingSnapshotDir(Path rootDir, Configuration conf) {
        return new Path(conf.get(SNAPSHOT_WORKING_DIR, SnapshotDescriptionUtils.getDefaultWorkingSnapshotDir(rootDir).toString()));
    }

    public static Path getWorkingSnapshotDir(HBaseProtos.SnapshotDescription snapshot, Path rootDir, Configuration conf) {
        return SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot.getName(), rootDir, conf);
    }

    public static Path getWorkingSnapshotDir(String snapshotName, Path rootDir, Configuration conf) {
        return SnapshotDescriptionUtils.getSpecifiedSnapshotDir(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir, conf), snapshotName);
    }

    private static final Path getSpecifiedSnapshotDir(Path snapshotsDir, String snapshotName) {
        return new Path(snapshotsDir, snapshotName);
    }

    public static final Path getSnapshotsDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static boolean isSubDirectoryOf(Path workingDir, Path rootDir) {
        return workingDir.toString().startsWith(rootDir.toString() + "/");
    }

    public static boolean isWithinDefaultWorkingDir(Path workingDir, Configuration conf) throws IOException {
        Path defaultWorkingDir = SnapshotDescriptionUtils.getDefaultWorkingSnapshotDir(FSUtils.getRootDir(conf));
        return workingDir.equals((Object)defaultWorkingDir) || SnapshotDescriptionUtils.isSubDirectoryOf(workingDir, defaultWorkingDir);
    }

    private static Path getDefaultWorkingSnapshotDir(Path rootDir) {
        return new Path(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), SNAPSHOT_TMP_DIR_NAME);
    }

    public static HBaseProtos.SnapshotDescription validate(HBaseProtos.SnapshotDescription snapshot, Configuration conf) throws IllegalArgumentException, IOException {
        if (!snapshot.hasTable()) {
            throw new IllegalArgumentException("Descriptor doesn't apply to a table, so we can't build it.");
        }
        long time = snapshot.getCreationTime();
        if (time == 0L) {
            time = EnvironmentEdgeManager.currentTime();
            LOG.debug((Object)("Creation time not specified, setting to:" + time + " (current time:" + EnvironmentEdgeManager.currentTime() + ")."));
            HBaseProtos.SnapshotDescription.Builder builder = snapshot.toBuilder();
            builder.setCreationTime(time);
            snapshot = builder.build();
        }
        if (SnapshotDescriptionUtils.isSecurityAvailable(conf)) {
            snapshot = SnapshotDescriptionUtils.writeAclToSnapshotDescription(snapshot, conf);
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSnapshotInfo(HBaseProtos.SnapshotDescription snapshot, Path workingDir, FileSystem fs) throws IOException {
        block5: {
            FsPermission perms = FSUtils.getFilePermissions(fs, fs.getConf(), "hbase.data.umask");
            Path snapshotInfo = new Path(workingDir, SNAPSHOTINFO_FILE);
            try (FSDataOutputStream out = FSUtils.create(fs, snapshotInfo, perms, true);){
                snapshot.writeTo((OutputStream)out);
            }
            catch (IOException e) {
                LOG.info((Object)("Deleting: " + snapshotInfo));
                if (fs.delete(snapshotInfo, false)) break block5;
                String msg = "Couldn't delete snapshot info file: " + snapshotInfo;
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseProtos.SnapshotDescription readSnapshotInfo(FileSystem fs, Path snapshotDir) throws CorruptedSnapshotException {
        HBaseProtos.SnapshotDescription snapshotDescription;
        block6: {
            Path snapshotInfo = new Path(snapshotDir, SNAPSHOTINFO_FILE);
            FSDataInputStream in = null;
            try {
                HBaseProtos.SnapshotDescription desc;
                in = fs.open(snapshotInfo);
                snapshotDescription = desc = HBaseProtos.SnapshotDescription.parseFrom((InputStream)in);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CorruptedSnapshotException("Couldn't read snapshot info from:" + snapshotInfo, (Exception)e);
                }
            }
            in.close();
        }
        return snapshotDescription;
    }

    public static void completeSnapshot(Path snapshotDir, Path workingDir, FileSystem fs, FileSystem workingDirFs, Configuration conf) throws SnapshotCreationException, IOException {
        URI rootURI;
        LOG.debug((Object)("Snapshot is done, just moving the snapshot from " + workingDir + " to " + snapshotDir));
        if (!workingDirFs.exists(workingDir)) {
            throw new IOException("Failed to moving nonexistent snapshot working directory " + workingDir + " to " + snapshotDir);
        }
        URI workingURI = workingDirFs.getUri();
        if (!(!SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories(workingURI, rootURI = fs.getUri()) && fs.rename(workingDir, snapshotDir) || FileUtil.copy((FileSystem)workingDirFs, (Path)workingDir, (FileSystem)fs, (Path)snapshotDir, (boolean)true, (boolean)true, (Configuration)conf))) {
            throw new SnapshotCreationException("Failed to copy working directory(" + workingDir + ") to completed directory(" + snapshotDir + ").");
        }
    }

    @VisibleForTesting
    static boolean shouldSkipRenameSnapshotDirectories(URI workingURI, URI rootURI) {
        if (workingURI.getScheme() == null && rootURI.getScheme() != null && !rootURI.getScheme().equalsIgnoreCase("file")) {
            return true;
        }
        if (workingURI.getScheme() != null && !workingURI.getScheme().equals(rootURI.getScheme())) {
            return true;
        }
        if (workingURI.getAuthority() == null && rootURI.getAuthority() != null) {
            return true;
        }
        if (workingURI.getAuthority() != null && !workingURI.getAuthority().equals(rootURI.getAuthority())) {
            return true;
        }
        if (workingURI.getUserInfo() == null && rootURI.getUserInfo() != null) {
            return true;
        }
        return workingURI.getUserInfo() != null && !workingURI.getUserInfo().equals(rootURI.getUserInfo());
    }

    public static boolean isSnapshotOwner(HBaseProtos.SnapshotDescription snapshot, User user) {
        if (user == null) {
            return false;
        }
        if (!snapshot.hasOwner()) {
            return false;
        }
        return snapshot.getOwner().equals(user.getShortName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSecurityAvailable(Configuration conf) throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            boolean bl;
            Admin admin = conn.getAdmin();
            try {
                bl = admin.tableExists(AccessControlLists.ACL_TABLE_NAME);
            }
            catch (Throwable throwable) {
                admin.close();
                throw throwable;
            }
            admin.close();
            return bl;
        }
    }

    private static HBaseProtos.SnapshotDescription writeAclToSnapshotDescription(final HBaseProtos.SnapshotDescription snapshot, final Configuration conf) throws IOException {
        ListMultimap perms = (ListMultimap)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<ListMultimap<String, TablePermission>>(){

            @Override
            public ListMultimap<String, TablePermission> run() throws Exception {
                return AccessControlLists.getTablePermissions(conf, TableName.valueOf((String)snapshot.getTable()));
            }
        });
        return snapshot.toBuilder().setUsersAndPermissions(ProtobufUtil.toUserTablePermissions((ListMultimap)perms)).build();
    }

    public static class CompletedSnaphotDirectoriesFilter
    extends FSUtils.BlackListDirFilter {
        public CompletedSnaphotDirectoriesFilter(FileSystem fs) {
            super(fs, Collections.singletonList(SnapshotDescriptionUtils.SNAPSHOT_TMP_DIR_NAME));
        }
    }
}

