/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.scram;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hbase.security.scram.RpcAuthMethod;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthMethod
extends RpcAuthMethod {
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthMethod.class);

    protected TokenAuthMethod(byte code, String simpleName, String mechanismName, UserGroupInformation.AuthenticationMethod authMethod) {
        super(code, simpleName, mechanismName, authMethod);
    }

    @Override
    public boolean isProxyAllowed() {
        return false;
    }

    @Override
    public UserGroupInformation getAuthorizedUgi(String authorizedId, SecretManager secretManager) throws IOException {
        Object tokenId = TokenAuthMethod.getIdentifier(authorizedId, secretManager);
        UserGroupInformation ugi = tokenId.getUser();
        if (ugi == null) {
            throw new AccessControlException("Can't retrieve username from tokenIdentifier.");
        }
        ugi.addTokenIdentifier(tokenId);
        return ugi;
    }

    @Override
    public boolean isSasl() {
        return true;
    }

    @Override
    public String getProtocol() throws IOException {
        return "default";
    }

    @Override
    public String getServerId() throws IOException {
        return "";
    }

    public static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password)).toCharArray();
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = TokenAuthMethod.decodeIdentifier(id);
        TokenIdentifier tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
        }
        return (T)tokenIdentifier;
    }

    public static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier));
    }

    public static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64((byte[])identifier.getBytes());
    }
}

