/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public final class AccessChecker {
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + AccessChecker.class.getName()));
    private TableAuthManager authManager;
    private boolean authorizationEnabled;

    public static boolean isAuthorizationSupported(Configuration conf) {
        return conf.getBoolean("hbase.security.authorization", false);
    }

    public AccessChecker(Configuration conf, ZooKeeperWatcher zkw) throws RuntimeException {
        if (zkw != null) {
            try {
                this.authManager = TableAuthManager.getOrCreate(zkw, conf);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining AccessChecker", ioe);
            }
        } else {
            throw new NullPointerException("Error obtaining AccessChecker, zk found null.");
        }
        this.authorizationEnabled = AccessChecker.isAuthorizationSupported(conf);
    }

    public TableAuthManager getAuthManager() {
        return this.authManager;
    }

    public void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            InetAddress remoteAddr = RpcServer.getRemoteAddress();
            AUDITLOG.trace("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (Serializable)(remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString());
        }
    }

    public void requirePermission(User user, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireTablePermission(User user, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, null, null, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                result.getParams().setFamily(family).setQualifier(qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
            result.getParams().setFamily(family).setQualifier(qualifier);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireAccess(User user, String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.hasAccess(user, tableName, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, null, null);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requirePermission(User user, String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(user, request, perm, null, null);
    }

    public void requireGlobalPermission(User user, String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        AuthResult result = null;
        if (this.authManager.authorize(user, perm)) {
            result = AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
            this.logResult(result);
        } else {
            result = AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
            this.logResult(result);
            if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
            }
        }
    }

    public void requireGlobalPermission(User user, String request, Permission.Action perm, String namespace) throws IOException {
        AuthResult authResult = null;
        if (this.authManager.authorize(user, perm)) {
            authResult = AuthResult.allow(request, "Global check allowed", user, perm, null);
            authResult.getParams().setNamespace(namespace);
            this.logResult(authResult);
        } else {
            authResult = AuthResult.deny(request, "Global check failed", user, perm, null);
            authResult.getParams().setNamespace(namespace);
            this.logResult(authResult);
            if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
            }
        }
    }

    public void requireNamespacePermission(User user, String request, String namespace, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireNamespacePermission(User user, String request, String namespace, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                result.getParams().setTableName(tableName).setFamilies(familyMap);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }
}

