/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class ReversedRegionScannerImpl
extends HRegion.RegionScannerImpl {
    ReversedRegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
        HRegion hRegion = region;
        Objects.requireNonNull(hRegion);
        super(hRegion, scan, additionalScanners, region);
    }

    @Override
    protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
        this.storeHeap = new ReversedKeyValueHeap(scanners, region.getComparator());
        if (!joinedScanners.isEmpty()) {
            this.joinedHeap = new ReversedKeyValueHeap(joinedScanners, region.getComparator());
        }
    }

    @Override
    protected boolean shouldStop(Cell currentRowCell) {
        if (currentRowCell == null) {
            return true;
        }
        if (this.stopRow == null || Bytes.equals((byte[])this.stopRow, (byte[])HConstants.EMPTY_START_ROW)) {
            return false;
        }
        int c = this.region.getComparator().compareRows(currentRowCell, this.stopRow, 0, this.stopRow.length);
        return c < 0 || c == 0 && !this.includeStopRow;
    }

    @Override
    protected boolean nextRow(ScannerContext scannerContext, byte[] currentRow, int offset, short length) throws IOException {
        assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
        byte[] row = new byte[length];
        System.arraycopy(currentRow, offset, row, 0, length);
        this.storeHeap.seekToPreviousRow((Cell)KeyValueUtil.createFirstOnRow((byte[])row));
        this.resetFilters();
        if (this.region.getCoprocessorHost() != null) {
            return this.region.getCoprocessorHost().postScannerFilterRow(this, currentRow, offset, length);
        }
        return true;
    }
}

