/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
public class DisableTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.DisableTableState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(DisableTableProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private final ProcedurePrepareLatch syncLatch;
    private TableName tableName;
    private boolean skipTableStateCheck;
    private UserGroupInformation user;
    private Boolean traceEnabled = null;

    public DisableTableProcedure() {
        this.syncLatch = null;
    }

    public DisableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck) {
        this(env, tableName, skipTableStateCheck, null);
    }

    public DisableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck, ProcedurePrepareLatch syncLatch) {
        this.tableName = tableName;
        this.skipTableStateCheck = skipTableStateCheck;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.syncLatch = syncLatch;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case DISABLE_TABLE_PREPARE: {
                    if (this.prepareDisable(env)) {
                        this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_PRE_OPERATION);
                        break;
                    }
                    assert (this.isFailed()) : "disable should have an exception here";
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case DISABLE_TABLE_PRE_OPERATION: {
                    this.preDisable(env, state);
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_SET_DISABLING_TABLE_STATE);
                    break;
                }
                case DISABLE_TABLE_SET_DISABLING_TABLE_STATE: {
                    DisableTableProcedure.setTableStateToDisabling(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_MARK_REGIONS_OFFLINE);
                    break;
                }
                case DISABLE_TABLE_MARK_REGIONS_OFFLINE: {
                    if (DisableTableProcedure.markRegionsOffline(env, this.tableName, true) == MarkRegionOfflineOpResult.MARK_ALL_REGIONS_OFFLINE_SUCCESSFUL) {
                        this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_SET_DISABLED_TABLE_STATE);
                        break;
                    }
                    LOG.trace((Object)"Retrying later to disable the missing regions");
                    break;
                }
                case DISABLE_TABLE_SET_DISABLED_TABLE_STATE: {
                    DisableTableProcedure.setTableStateToDisabled(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_POST_OPERATION);
                    break;
                }
                case DISABLE_TABLE_POST_OPERATION: {
                    this.postDisable(env, state);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | HBaseException e) {
            LOG.warn((Object)("Retriable error trying to disable table=" + this.tableName + " state=" + state), e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException {
        if (state == MasterProcedureProtos.DisableTableState.DISABLE_TABLE_PREPARE) {
            this.undoTableStateChange(env);
            ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected MasterProcedureProtos.DisableTableState getState(int stateId) {
        return MasterProcedureProtos.DisableTableState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.DisableTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.DisableTableState getInitialState() {
        return MasterProcedureProtos.DisableTableState.DISABLE_TABLE_PREPARE;
    }

    protected void setNextState(MasterProcedureProtos.DisableTableState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("disable-table", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized((Procedure)this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableExclusiveLock((Procedure)this, this.tableName);
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableExclusiveLock((Procedure)this, this.tableName);
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.DisableTableStateData.Builder disableTableMsg = MasterProcedureProtos.DisableTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setSkipTableStateCheck(this.skipTableStateCheck);
        disableTableMsg.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.DisableTableStateData disableTableMsg = MasterProcedureProtos.DisableTableStateData.parseDelimitedFrom((InputStream)stream);
        this.user = MasterProcedureUtil.toUserInfo(disableTableMsg.getUserInfo());
        this.tableName = ProtobufUtil.toTableName((TableProtos.TableName)disableTableMsg.getTableName());
        this.skipTableStateCheck = disableTableMsg.getSkipTableStateCheck();
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.DISABLE;
    }

    private boolean prepareDisable(MasterProcedureEnv env) throws HBaseException, IOException {
        boolean canTableBeDisabled = true;
        if (this.tableName.equals((Object)TableName.META_TABLE_NAME)) {
            this.setFailure("master-disable-table", (Throwable)((Object)new ConstraintException("Cannot disable catalog table")));
            canTableBeDisabled = false;
        } else if (!MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)this.tableName)) {
            this.setFailure("master-disable-table", new TableNotFoundException(this.tableName));
            canTableBeDisabled = false;
        } else if (!this.skipTableStateCheck) {
            TableStateManager tsm = env.getMasterServices().getAssignmentManager().getTableStateManager();
            if (!tsm.setTableStateIfInStates(this.tableName, ZooKeeperProtos.Table.State.DISABLING, ZooKeeperProtos.Table.State.DISABLING, ZooKeeperProtos.Table.State.ENABLED)) {
                LOG.info((Object)("Table " + this.tableName + " isn't enabled; skipping disable"));
                this.setFailure("master-disable-table", (Throwable)new TableNotEnabledException(this.tableName));
                canTableBeDisabled = false;
            }
        }
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
        return canTableBeDisabled;
    }

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intended")
    private void undoTableStateChange(MasterProcedureEnv env) {
        if (!this.skipTableStateCheck) {
            try {
                if (env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(this.tableName, ZooKeeperProtos.Table.State.DISABLING)) {
                    EnableTableProcedure.setTableStateToEnabled(env, this.tableName);
                }
            }
            catch (Exception e) {
                LOG.trace((Object)e.getMessage());
            }
        }
    }

    protected void preDisable(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    protected static void setTableStateToDisabling(MasterProcedureEnv env, TableName tableName) throws HBaseException, IOException {
        env.getMasterServices().getAssignmentManager().getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
    }

    protected static MarkRegionOfflineOpResult markRegionsOffline(MasterProcedureEnv env, TableName tableName, Boolean retryRequired) throws IOException {
        int maxTry = retryRequired != false ? 10 : 1;
        MarkRegionOfflineOpResult operationResult = MarkRegionOfflineOpResult.BULK_ASSIGN_REGIONS_FAILED;
        do {
            try {
                operationResult = DisableTableProcedure.markRegionsOffline(env, tableName);
                if (operationResult == MarkRegionOfflineOpResult.MARK_ALL_REGIONS_OFFLINE_SUCCESSFUL) break;
                --maxTry;
            }
            catch (Exception e) {
                LOG.warn((Object)("Received exception while marking regions online. tries left: " + maxTry), (Throwable)e);
                if (--maxTry > 0) continue;
                throw e;
            }
        } while (maxTry > 0);
        if (operationResult != MarkRegionOfflineOpResult.MARK_ALL_REGIONS_OFFLINE_SUCCESSFUL) {
            LOG.warn((Object)("Some or all regions of the Table '" + tableName + "' were still online"));
        }
        return operationResult;
    }

    private static MarkRegionOfflineOpResult markRegionsOffline(MasterProcedureEnv env, TableName tableName) throws IOException {
        MarkRegionOfflineOpResult operationResult = MarkRegionOfflineOpResult.MARK_ALL_REGIONS_OFFLINE_SUCCESSFUL;
        List<HRegionInfo> regions = env.getMasterServices().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
        if (regions.size() > 0) {
            LOG.info((Object)("Offlining " + regions.size() + " regions."));
            BulkDisabler bd = new BulkDisabler(env, tableName, regions);
            try {
                if (!bd.bulkAssign()) {
                    operationResult = MarkRegionOfflineOpResult.BULK_ASSIGN_REGIONS_FAILED;
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Disable was interrupted");
                Thread.currentThread().interrupt();
                operationResult = MarkRegionOfflineOpResult.MARK_ALL_REGIONS_OFFLINE_INTERRUPTED;
            }
        }
        return operationResult;
    }

    protected static void setTableStateToDisabled(MasterProcedureEnv env, TableName tableName) throws HBaseException, IOException {
        env.getMasterServices().getAssignmentManager().getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.DISABLED);
        LOG.info((Object)("Disabled table, " + tableName + ", is completed."));
    }

    protected void postDisable(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private void runCoprocessorAction(MasterProcedureEnv env, final MasterProcedureProtos.DisableTableState state) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    switch (state) {
                        case DISABLE_TABLE_PRE_OPERATION: {
                            cpHost.preDisableTableHandler(DisableTableProcedure.this.tableName);
                            break;
                        }
                        case DISABLE_TABLE_POST_OPERATION: {
                            cpHost.postDisableTableHandler(DisableTableProcedure.this.tableName);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this + " unhandled state=" + state);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private static class BulkDisabler
    extends BulkAssigner {
        private final AssignmentManager assignmentManager;
        private final List<HRegionInfo> regions;
        private final TableName tableName;
        private final int waitingTimeForEvents;

        public BulkDisabler(MasterProcedureEnv env, TableName tableName, List<HRegionInfo> regions) {
            super(env.getMasterServices());
            this.assignmentManager = env.getMasterServices().getAssignmentManager();
            this.tableName = tableName;
            this.regions = regions;
            this.waitingTimeForEvents = env.getMasterServices().getConfiguration().getInt("hbase.master.event.waiting.time", 1000);
        }

        @Override
        protected void populatePool(ExecutorService pool) {
            RegionStates regionStates = this.assignmentManager.getRegionStates();
            for (final HRegionInfo region : this.regions) {
                if (regionStates.isRegionInTransition(region) && !regionStates.isRegionInState(region, RegionState.State.FAILED_CLOSE)) continue;
                pool.execute(Trace.wrap((String)"DisableTableHandler.BulkDisabler", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        assignmentManager.unassign(region);
                    }
                }));
            }
        }

        @Override
        protected boolean waitUntilDone(long timeout) throws InterruptedException {
            long startTime = EnvironmentEdgeManager.currentTime();
            long remaining = timeout;
            List<HRegionInfo> regions = null;
            long lastLogTime = startTime;
            while (!this.server.isStopped() && remaining > 0L) {
                Thread.sleep(this.waitingTimeForEvents);
                regions = this.assignmentManager.getRegionStates().getRegionsOfTable(this.tableName);
                long now = EnvironmentEdgeManager.currentTime();
                if (LOG.isDebugEnabled() && now - lastLogTime > 10000L) {
                    lastLogTime = now;
                    LOG.debug((Object)("Disable waiting until done; " + remaining + " ms remaining; " + regions));
                }
                if (regions.isEmpty()) break;
                remaining = timeout - (now - startTime);
            }
            return regions != null && regions.isEmpty();
        }
    }

    static enum MarkRegionOfflineOpResult {
        MARK_ALL_REGIONS_OFFLINE_SUCCESSFUL,
        BULK_ASSIGN_REGIONS_FAILED,
        MARK_ALL_REGIONS_OFFLINE_INTERRUPTED;

    }
}

