/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSecureBulkLoadEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureBulkLoadEndpoint.class);
    private static TableName TABLE = TableName.valueOf((byte[])Bytes.toBytes((String)"TestSecureBulkLoadManager"));
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] COLUMN = Bytes.toBytes((String)"column");
    private static byte[] key1 = Bytes.toBytes((String)"row1");
    private static byte[] key2 = Bytes.toBytes((String)"row2");
    private static byte[] key3 = Bytes.toBytes((String)"row3");
    private static byte[] value1 = Bytes.toBytes((String)"t1");
    private static byte[] value3 = Bytes.toBytes((String)"t3");
    private static byte[] SPLIT_ROWKEY = key2;
    private Thread ealierBulkload;
    private Thread laterBulkload;
    protected static final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private static Configuration conf = testUtil.getConfiguration();

    @BeforeClass
    public static void setUp() throws Exception {
        conf.set("hbase.coprocessor.region.classes", SecureBulkLoadEndpoint.class.getName());
        testUtil.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        testUtil.shutdownMiniCluster();
        testUtil.cleanupTestDir();
    }

    @Test
    public void testFileSystemsWithoutPermissionSupport() {
        Configuration emptyConf = new Configuration(false);
        Configuration defaultConf = HBaseConfiguration.create();
        HashSet<String> expectedDefaultIgnoredSchemes = new HashSet<String>(Arrays.asList(StringUtils.split((String)"s3,s3a,s3n,wasb,wasbs,swift,adfs,abfs,viewfs", (char)',')));
        SecureBulkLoadEndpoint endpoint = new SecureBulkLoadEndpoint();
        Set defaultIgnoredSchemes = endpoint.getFileSystemSchemesWithoutPermissionSupport(emptyConf);
        Assert.assertEquals((Object)defaultIgnoredSchemes, expectedDefaultIgnoredSchemes);
        defaultIgnoredSchemes = endpoint.getFileSystemSchemesWithoutPermissionSupport(defaultConf);
        Assert.assertEquals((Object)defaultIgnoredSchemes, expectedDefaultIgnoredSchemes);
        defaultConf.set("hbase.secure.bulkload.fs.permission.lacking", "foo,bar");
        defaultIgnoredSchemes = endpoint.getFileSystemSchemesWithoutPermissionSupport(defaultConf);
        Assert.assertEquals((Object)defaultIgnoredSchemes, new HashSet<String>(Arrays.asList("foo", "bar")));
    }

    @Test
    public void testForRaceCondition() throws Exception {
        testUtil.createTable(TABLE, FAMILY, Bytes.toByteArrays((byte[])SPLIT_ROWKEY));
        testUtil.waitUntilAllRegionsAssigned(TABLE);
        SecureBulkLoadEndpoint.Consumer<Region> fsCreatedListener = new SecureBulkLoadEndpoint.Consumer<Region>(){

            public void accept(Region hRegion) {
                if (hRegion.getRegionInfo().containsRow(key3)) {
                    Threads.shutdown((Thread)TestSecureBulkLoadEndpoint.this.ealierBulkload);
                }
            }
        };
        SecureBulkLoadEndpoint.setFsCreatedListener((SecureBulkLoadEndpoint.Consumer)fsCreatedListener);
        Path rootdir = testUtil.getMiniHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getFileSystem().getHomeDirectory();
        final Path dir1 = new Path(rootdir, "dir1");
        this.prepareHFile(dir1, key1, value1);
        final Path dir2 = new Path(rootdir, "dir2");
        this.prepareHFile(dir2, key3, value3);
        final AtomicReference t1Exception = new AtomicReference();
        final AtomicReference t2Exception = new AtomicReference();
        this.ealierBulkload = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestSecureBulkLoadEndpoint.this.doBulkloadWithoutRetry(dir1);
                }
                catch (Exception e) {
                    LOG.error("bulk load failed .", (Throwable)e);
                    t1Exception.set(e);
                }
            }
        });
        this.laterBulkload = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestSecureBulkLoadEndpoint.this.doBulkloadWithoutRetry(dir2);
                }
                catch (Exception e) {
                    LOG.error("bulk load failed .", (Throwable)e);
                    t2Exception.set(e);
                }
            }
        });
        this.ealierBulkload.start();
        this.laterBulkload.start();
        Threads.shutdown((Thread)this.ealierBulkload);
        Threads.shutdown((Thread)this.laterBulkload);
        Assert.assertNull(t1Exception.get());
        Assert.assertNull(t2Exception.get());
        Get get1 = new Get(key1);
        Get get3 = new Get(key3);
        Table t = testUtil.getConnection().getTable(TABLE);
        Result r = t.get(get1);
        Assert.assertArrayEquals((byte[])r.getValue(FAMILY, COLUMN), (byte[])value1);
        r = t.get(get3);
        Assert.assertArrayEquals((byte[])r.getValue(FAMILY, COLUMN), (byte[])value3);
    }

    private void doBulkloadWithoutRetry(Path dir) throws Exception {
        Connection connection = testUtil.getConnection();
        LoadIncrementalHFiles h = new LoadIncrementalHFiles(conf){

            protected void bulkLoadPhase(Table table, Connection conn, ExecutorService pool, Deque<LoadIncrementalHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups) throws IOException {
                super.bulkLoadPhase(table, conn, pool, queue, regionGroups);
                throw new MyExceptionToAvoidRetry();
            }
        };
        try {
            h.doBulkLoad(dir, (Admin)testUtil.getHBaseAdmin(), connection.getTable(TABLE), connection.getRegionLocator(TABLE));
            Assert.fail((String)"MyExceptionToAvoidRetry is expected");
        }
        catch (MyExceptionToAvoidRetry myExceptionToAvoidRetry) {
            // empty catch block
        }
    }

    private void prepareHFile(Path dir, byte[] key, byte[] value) throws Exception {
        HTableDescriptor desc = testUtil.getHBaseAdmin().getTableDescriptor(TABLE);
        HColumnDescriptor family = desc.getFamily(FAMILY);
        Compression.Algorithm compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        CacheConfig writerCacheConf = new CacheConfig(conf, family);
        writerCacheConf.setCacheDataOnWrite(false);
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(false).withIncludesTags(true).withCompression(compression).withCompressTags(family.isCompressTags()).withChecksumType(HStore.getChecksumType((Configuration)conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum((Configuration)conf)).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).withEncryptionContext(Encryption.Context.NONE).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
        StoreFile.WriterBuilder builder = new StoreFile.WriterBuilder(conf, writerCacheConf, dir.getFileSystem(conf)).withOutputDir(new Path(dir, family.getNameAsString())).withBloomType(family.getBloomFilterType()).withMaxKeyCount(Integer.MAX_VALUE).withFileContext(hFileContext);
        StoreFile.Writer writer = builder.build();
        Put put = new Put(key);
        put.addColumn(FAMILY, COLUMN, value);
        for (Cell c : put.get(FAMILY, COLUMN)) {
            writer.append(c);
        }
        writer.close();
    }

    class MyExceptionToAvoidRetry
    extends DoNotRetryIOException {
        MyExceptionToAvoidRetry() {
        }
    }
}

