/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestObservedExceptionsInBatch {
    private HRegion.ObservedExceptionsInBatch observedExceptions;

    @Before
    public void setup() {
        this.observedExceptions = new HRegion.ObservedExceptionsInBatch();
    }

    @Test
    public void testNoObservationsOnCreation() {
        Assert.assertFalse((boolean)this.observedExceptions.hasSeenFailedSanityCheck());
        Assert.assertFalse((boolean)this.observedExceptions.hasSeenNoSuchFamily());
        Assert.assertFalse((boolean)this.observedExceptions.hasSeenWrongRegion());
    }

    @Test
    public void testObservedAfterRecording() {
        this.observedExceptions.sawFailedSanityCheck();
        Assert.assertTrue((boolean)this.observedExceptions.hasSeenFailedSanityCheck());
        this.observedExceptions.sawNoSuchFamily();
        Assert.assertTrue((boolean)this.observedExceptions.hasSeenNoSuchFamily());
        this.observedExceptions.sawWrongRegion();
        Assert.assertTrue((boolean)this.observedExceptions.hasSeenWrongRegion());
    }
}

