/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TestStoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFSErrorsExposed {
    private static final Log LOG = LogFactory.getLog(TestFSErrorsExposed.class);
    HBaseTestingUtility util = new HBaseTestingUtility();

    @Test
    public void testHFileScannerThrowsErrors() throws IOException {
        Path hfilePath = new Path(new Path(this.util.getDataTestDir("internalScannerExposesErrors"), "regionname"), "familyname");
        HFileSystem hfs = (HFileSystem)this.util.getTestFileSystem();
        FaultyFileSystem faultyfs = new FaultyFileSystem(hfs.getBackingFs());
        HFileSystem fs = new HFileSystem((FileSystem)faultyfs);
        CacheConfig cacheConf = new CacheConfig(this.util.getConfiguration());
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.util.getConfiguration(), cacheConf, (FileSystem)hfs).withOutputDir(hfilePath).withFileContext(meta).build();
        TestStoreFile.writeStoreFile(writer, Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qual"));
        StoreFile sf = new StoreFile((FileSystem)fs, writer.getPath(), this.util.getConfiguration(), cacheConf, BloomType.NONE);
        StoreFile.Reader reader = sf.createReader();
        HFileScanner scanner = reader.getScanner(false, true);
        FaultyInputStream inStream = faultyfs.inStreams.get(0).get();
        Assert.assertNotNull((Object)((Object)inStream));
        scanner.seekTo();
        Assert.assertTrue((boolean)scanner.next());
        faultyfs.startFaults();
        try {
            int scanned = 0;
            while (scanner.next()) {
                ++scanned;
            }
            Assert.fail((String)"Scanner didn't throw after faults injected");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Got expected exception", (Throwable)ioe);
            Assert.assertTrue((boolean)ioe.getMessage().contains("Fault"));
        }
        reader.close(true);
    }

    @Test
    public void testStoreFileScannerThrowsErrors() throws IOException {
        Path hfilePath = new Path(new Path(this.util.getDataTestDir("internalScannerExposesErrors"), "regionname"), "familyname");
        HFileSystem hfs = (HFileSystem)this.util.getTestFileSystem();
        FaultyFileSystem faultyfs = new FaultyFileSystem(hfs.getBackingFs());
        HFileSystem fs = new HFileSystem((FileSystem)faultyfs);
        CacheConfig cacheConf = new CacheConfig(this.util.getConfiguration());
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.util.getConfiguration(), cacheConf, (FileSystem)hfs).withOutputDir(hfilePath).withFileContext(meta).build();
        TestStoreFile.writeStoreFile(writer, Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qual"));
        StoreFile sf = new StoreFile((FileSystem)fs, writer.getPath(), this.util.getConfiguration(), cacheConf, BloomType.NONE);
        List scanners = StoreFileScanner.getScannersForStoreFiles(Collections.singletonList(sf), (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)0L);
        KeyValueScanner scanner = (KeyValueScanner)scanners.get(0);
        FaultyInputStream inStream = faultyfs.inStreams.get(0).get();
        Assert.assertNotNull((Object)((Object)inStream));
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        Assert.assertNotNull((Object)scanner.next());
        faultyfs.startFaults();
        try {
            int scanned = 0;
            while (scanner.next() != null) {
                ++scanned;
            }
            Assert.fail((String)"Scanner didn't throw after faults injected");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Got expected exception", (Throwable)ioe);
            Assert.assertTrue((boolean)ioe.getMessage().contains("Could not iterate"));
        }
        scanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFullSystemBubblesFSErrors() throws Exception {
        Assume.assumeTrue((!this.util.isReadShortCircuitOn() ? 1 : 0) != 0);
        try {
            this.util.getConfiguration().setInt("hbase.client.retries.number", 1);
            this.util.getConfiguration().setInt("hbase.client.scanner.timeout.period", 90000);
            this.util.startMiniCluster(1);
            TableName tableName = TableName.valueOf((String)"table");
            byte[] fam = Bytes.toBytes((String)"fam");
            HBaseAdmin admin = new HBaseAdmin(this.util.getConfiguration());
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor(fam).setMaxVersions(1).setBlockCacheEnabled(false));
            admin.createTable(desc);
            try (Table table = this.util.getConnection().getTable(tableName);){
                this.util.loadTable(table, fam, false);
                this.util.flush();
                this.util.countRows(table);
                this.util.getDFSCluster().shutdownDataNodes();
                try {
                    this.util.countRows(table);
                    Assert.fail((String)"Did not fail to count after removing data");
                }
                catch (Exception e) {
                    LOG.info((Object)"Got expected error", (Throwable)e);
                    Assert.assertTrue((boolean)e.getMessage().contains("Could not seek"));
                }
            }
            this.util.getDFSCluster().restartDataNodes();
        }
        finally {
            MiniHBaseCluster cluster = this.util.getMiniHBaseCluster();
            if (cluster != null) {
                cluster.killAll();
            }
            this.util.shutdownMiniCluster();
        }
    }

    static class FaultyInputStream
    extends FSDataInputStream {
        boolean faultsStarted = false;

        public FaultyInputStream(InputStream in) throws IOException {
            super(in);
        }

        public void startFaults() {
            this.faultsStarted = true;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.injectFault();
            return ((PositionedReadable)this.in).read(position, buffer, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.faultsStarted) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyInputStream>> inStreams = new ArrayList<SoftReference<FaultyInputStream>>();

        public FaultyFileSystem(FileSystem testFileSystem) {
            super(testFileSystem);
        }

        public FSDataInputStream open(Path p, int bufferSize) throws IOException {
            FSDataInputStream orig = this.fs.open(p, bufferSize);
            FaultyInputStream faulty = new FaultyInputStream((InputStream)orig);
            this.inStreams.add(new SoftReference<FaultyInputStream>(faulty));
            return faulty;
        }

        public void startFaults() {
            for (SoftReference<FaultyInputStream> is : this.inStreams) {
                FaultyInputStream fis = is.get();
                if (fis == null) continue;
                fis.startFaults();
            }
        }
    }
}

