/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCheckAndMutate {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutate() throws Throwable {
        TableName tableName = TableName.valueOf((String)"TestPutWithDelete");
        byte[] rowKey = Bytes.toBytes((String)"12345");
        byte[] family = Bytes.toBytes((String)"cf");
        TEST_UTIL.waitTableAvailable(tableName.getName(), 5000L);
        try (HTable table = TEST_UTIL.createTable(tableName, family);){
            Put put = new Put(rowKey);
            put.add(family, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
            put.add(family, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
            put.add(family, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
            table.put(put);
            Get get = new Get(rowKey);
            Result result = table.get(get);
            Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"A"))).equals("a"));
            Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"B"))).equals("b"));
            Assert.assertTrue((String)"Column C value should be c", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"C"))).equals("c"));
            RowMutations rm = new RowMutations(rowKey);
            put = new Put(rowKey);
            put.add(family, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
            put.add(family, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
            rm.add(put);
            Delete del = new Delete(rowKey);
            del.deleteColumn(family, Bytes.toBytes((String)"C"));
            rm.add(del);
            boolean res = table.checkAndMutate(rowKey, family, Bytes.toBytes((String)"A"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)"a"), rm);
            Assert.assertTrue((boolean)res);
            get = new Get(rowKey);
            result = table.get(get);
            Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"A"))).equals("a"));
            Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"B"))).equals("b"));
            Assert.assertTrue((String)"Column C should not exist", (result.getValue(family, Bytes.toBytes((String)"C")) == null ? 1 : 0) != 0);
            try {
                Put p = new Put(rowKey);
                p.add(new byte[]{98, 111, 103, 117, 115}, new byte[]{65}, new byte[0]);
                rm = new RowMutations(rowKey);
                rm.add(p);
                table.checkAndMutate(rowKey, family, Bytes.toBytes((String)"A"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)"a"), rm);
                Assert.fail((String)"Expected NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                try {
                    throw e.getCause(0);
                }
                catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testCheckRowAndMutateDifferentRow() throws IOException {
        TableName tableName = TableName.valueOf((String)"TestCheckRowAndMutateDifferentRow");
        byte[] family = Bytes.toBytes((String)"f");
        TEST_UTIL.createTable(tableName, family);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            byte[] row1 = Bytes.toBytes((String)"row1");
            byte[] qualifier = Bytes.toBytes((String)"q1");
            byte[] value1 = Bytes.toBytes((String)"value1");
            Put put = new Put(row1);
            put.addColumn(family, qualifier, value1);
            table.put(put);
            Result result = table.get(new Get(row1));
            Assert.assertArrayEquals((String)"the value of column q in row1 should be value1", (byte[])value1, (byte[])result.getValue(family, qualifier));
            byte[] row2 = Bytes.toBytes((String)"row2");
            byte[] value2 = Bytes.toBytes((String)"value2");
            RowMutations mutations = new RowMutations(row2);
            put = new Put(row2);
            put.addColumn(family, qualifier, value2);
            mutations.add(put);
            Assert.assertTrue((boolean)table.checkAndMutate(row1, family, qualifier, CompareFilter.CompareOp.GREATER, value2, mutations));
            result = table.get(new Get(row2));
            Assert.assertArrayEquals((String)"the value of column q in row2 should be value2", (byte[])value2, (byte[])result.getValue(family, qualifier));
        }
    }
}

