/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.cli.CliException;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ZooKeeperMainServer {
    private static final String SERVER_ARG = "-server";

    public String parse(Configuration c) {
        return ZKConfig.getZKQuorumServersString((Configuration)c);
    }

    private static boolean hasServer(String[] args) {
        return args.length > 0 && args[0].equals(SERVER_ARG);
    }

    private static boolean hasCommandLineArguments(String[] args) {
        if (ZooKeeperMainServer.hasServer(args)) {
            if (args.length < 2) {
                throw new IllegalStateException("-server param but no value");
            }
            return args.length > 2;
        }
        return args.length > 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf;
        String hostport;
        String[] newArgs = args;
        if (!ZooKeeperMainServer.hasServer(args) && (hostport = new ZooKeeperMainServer().parse(conf = HBaseConfiguration.create())) != null && hostport.length() > 0) {
            newArgs = new String[args.length + 2];
            System.arraycopy(args, 0, newArgs, 2, args.length);
            newArgs[0] = SERVER_ARG;
            newArgs[1] = hostport;
        }
        if (ZooKeeperMainServer.hasCommandLineArguments(args)) {
            HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain zkm = new HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain(newArgs);
            zkm.runCmdLine();
        } else {
            ZooKeeperMain.main((String[])newArgs);
        }
    }

    private static class HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain
    extends ZooKeeperMain {
        public HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain(String[] args) throws IOException, InterruptedException {
            super(args);
            long startTime = System.currentTimeMillis();
            while (!this.zk.getState().isConnected()) {
                Thread.sleep(1L);
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                throw new InterruptedException("Failed connect " + this.zk);
            }
        }

        void runCmdLine() throws IOException, InterruptedException, CliException {
            this.processCmd(this.cl);
            System.exit(0);
        }
    }
}

