/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.net.Address;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RSGroupInfo {
    public static final String DEFAULT_GROUP = "default";
    public static final String NAMESPACE_DESC_PROP_GROUP = "hbase.rsgroup.name";
    private String name;
    private Set<Address> servers;
    private NavigableSet<TableName> tables;

    public RSGroupInfo(String name) {
        this(name, Sets.newHashSet(), Sets.newTreeSet());
    }

    RSGroupInfo(String name, Set<Address> servers, NavigableSet<TableName> tables) {
        this.name = name;
        this.servers = servers;
        this.tables = tables;
    }

    public RSGroupInfo(RSGroupInfo src) {
        this.name = src.getName();
        this.servers = Sets.newHashSet(src.getServers());
        this.tables = Sets.newTreeSet(src.getTables());
    }

    public String getName() {
        return this.name;
    }

    public void addServer(Address server) {
        this.servers.add(server);
    }

    public void addAllServers(Collection<Address> addresses) {
        this.servers.addAll(addresses);
    }

    public boolean containsServer(Address address) {
        return this.servers.contains(address);
    }

    public Set<Address> getServers() {
        return this.servers;
    }

    public boolean removeServer(Address address) {
        return this.servers.remove(address);
    }

    public NavigableSet<TableName> getTables() {
        return this.tables;
    }

    public void addTable(TableName table) {
        this.tables.add(table);
    }

    public void addAllTables(Collection<TableName> arg) {
        this.tables.addAll(arg);
    }

    public boolean containsTable(TableName table) {
        return this.tables.contains(table);
    }

    public boolean removeTable(TableName table) {
        return this.tables.remove(table);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name:");
        sb.append(this.name);
        sb.append(", ");
        sb.append(" Servers:");
        sb.append(this.servers);
        sb.append(", ");
        sb.append(" Tables:");
        sb.append(this.tables);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSGroupInfo RSGroupInfo2 = (RSGroupInfo)o;
        if (!this.name.equals(RSGroupInfo2.name)) {
            return false;
        }
        if (!this.servers.equals(RSGroupInfo2.servers)) {
            return false;
        }
        return this.tables.equals(RSGroupInfo2.tables);
    }

    public int hashCode() {
        int result = this.servers.hashCode();
        result = 31 * result + this.tables.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

