/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestEnableRSGroups {
    protected static final Logger LOG = LoggerFactory.getLogger(TestEnableRSGroups.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = TEST_UTIL.getConfiguration();

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testEnableRSGroups() throws IOException, InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().stopMaster(0);
        LOG.info("stopped master...");
        conf.set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        conf.set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getMiniHBaseCluster().setConf(conf);
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster(60000L);
        LOG.info("started master...");
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public boolean evaluate() throws IOException {
                return TEST_UTIL.getMiniHBaseCluster().getMaster() != null;
            }

            public String explainFailure() throws IOException {
                return "Master failed to start up";
            }
        });
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public boolean evaluate() throws IOException {
                RSGroupBasedLoadBalancer loadBalancer = (RSGroupBasedLoadBalancer)TEST_UTIL.getMiniHBaseCluster().getMaster().getLoadBalancer();
                return loadBalancer != null && loadBalancer.isOnline();
            }

            public String explainFailure() throws IOException {
                return "RSGroupBasedLoadBalancer failed to come online";
            }
        });
    }
}

