/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRSGroupsOfflineMode {
    private static final Log LOG = LogFactory.getLog(TestRSGroupsOfflineMode.class);
    private static HMaster master;
    private static HBaseAdmin hbaseAdmin;
    private static HBaseTestingUtility TEST_UTIL;
    private static HBaseCluster cluster;
    private static RSGroupAdminEndpoint RSGroupAdminEndpoint;
    public static final long WAIT_TIMEOUT = 300000L;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.master.wait.on.regionservers.mintostart", "1");
        TEST_UTIL.startMiniCluster(2, 3);
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((MiniHBaseCluster)cluster).getMaster();
        master.balanceSwitch(false);
        hbaseAdmin = TEST_UTIL.getHBaseAdmin();
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline() && master.getServerManager().getOnlineServersList().size() >= 3;
            }
        });
        RSGroupAdminEndpoint = (RSGroupAdminEndpoint)master.getMasterCoprocessorHost().findCoprocessors(RSGroupAdminEndpoint.class).get(0);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testOffline() throws Exception, InterruptedException {
        final TableName failoverTable = TableName.valueOf((String)"testOffline");
        TEST_UTIL.createTable(failoverTable, Bytes.toBytes((String)"f"));
        RSGroupAdminClient groupAdmin = new RSGroupAdminClient(TEST_UTIL.getConnection());
        HRegionServer killRS = ((MiniHBaseCluster)cluster).getRegionServer(0);
        final HRegionServer groupRS = ((MiniHBaseCluster)cluster).getRegionServer(1);
        final HRegionServer failoverRS = ((MiniHBaseCluster)cluster).getRegionServer(2);
        String newGroup = "my_group";
        groupAdmin.addRSGroup(newGroup);
        if (master.getAssignmentManager().getRegionStates().getRegionAssignments().containsValue(failoverRS.getServerName())) {
            for (HRegionInfo regionInfo : hbaseAdmin.getOnlineRegions(failoverRS.getServerName())) {
                hbaseAdmin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)failoverRS.getServerName().getServerName()));
            }
            LOG.info((Object)"Waiting for region unassignments on failover RS...");
            TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return master.getServerManager().getLoad(failoverRS.getServerName()).getRegionsLoad().size() > 0;
                }
            });
        }
        groupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{groupRS.getServerName().getAddress()}), newGroup);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return groupRS.getNumberOfOnlineRegions() < 1 && master.getAssignmentManager().getRegionStates().getRegionsInTransition().size() < 1;
            }
        });
        groupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{RSGroupInfoManager.RSGROUP_TABLE_NAME}), newGroup);
        LOG.info((Object)"Waiting for move table...");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return groupRS.getNumberOfOnlineRegions() == 1;
            }
        });
        groupRS.stop("die");
        TEST_UTIL.getHBaseCluster().getMaster().stopMaster();
        LOG.info((Object)"Waiting for offline mode...");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TEST_UTIL.getHBaseCluster().getMaster() != null && TEST_UTIL.getHBaseCluster().getMaster().isActiveMaster() && TEST_UTIL.getHBaseCluster().getMaster().isInitialized() && TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServers().size() <= 3;
            }
        });
        RSGroupInfoManager groupMgr = RSGroupAdminEndpoint.getGroupInfoManager();
        Assert.assertFalse((boolean)groupMgr.isOnline());
        Assert.assertEquals((Object)newGroup, (Object)groupMgr.getRSGroupOfTable(RSGroupInfoManager.RSGROUP_TABLE_NAME));
        Assert.assertEquals((Object)"default", (Object)groupMgr.getRSGroupOfTable(failoverTable));
        killRS.stop("die");
        master = TEST_UTIL.getHBaseCluster().getMaster();
        LOG.info((Object)"Waiting for new table assignment...");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return failoverRS.getOnlineRegions(failoverTable).size() >= 1;
            }
        });
        Assert.assertEquals((long)0L, (long)failoverRS.getOnlineRegions(RSGroupInfoManager.RSGROUP_TABLE_NAME).size());
        master.stopMaster();
    }
}

