/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.RSGroupableBalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal
extends RSGroupableBalancerTestBase {
    private static RSGroupBasedLoadBalancer loadBalancer;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        groups = new String[]{"default"};
        servers = TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.generateServers(3);
        groupMap = TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.constructGroupInfo(servers, groups);
        tableDescs = TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.constructTableDesc(false);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regions.slop", "0");
        conf.setFloat("hbase.master.balancer.stochastic.readRequestCost", 10000.0f);
        conf.set("hbase.rsgroup.grouploadbalancer.class", StochasticLoadBalancer.class.getCanonicalName());
        loadBalancer = new RSGroupBasedLoadBalancer(TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.getMockedGroupInfoManager());
        loadBalancer.setMasterServices(TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.getMockedMaster());
        loadBalancer.setConf(conf);
        loadBalancer.initialize();
    }

    private ServerLoad mockServerLoadWithReadRequests(ServerName server, List<HRegionInfo> regionsOnServer, long readRequestCount) {
        ServerLoad serverMetrics = (ServerLoad)Mockito.mock(ServerLoad.class);
        TreeMap<byte[], RegionLoad> regionLoadMap = new TreeMap<byte[], RegionLoad>(Bytes.BYTES_COMPARATOR);
        for (HRegionInfo info : regionsOnServer) {
            RegionLoad rl = (RegionLoad)Mockito.mock(RegionLoad.class);
            Mockito.when((Object)rl.getReadRequestsCount()).thenReturn((Object)readRequestCount);
            Mockito.when((Object)rl.getWriteRequestsCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getMemStoreSizeMB()).thenReturn((Object)0);
            Mockito.when((Object)rl.getStorefileSizeMB()).thenReturn((Object)0);
            regionLoadMap.put(info.getRegionName(), rl);
        }
        Mockito.when((Object)serverMetrics.getRegionsLoad()).thenReturn(regionLoadMap);
        return serverMetrics;
    }

    @Test
    public void testBalanceCluster() throws HBaseIOException {
        HashMap<ServerName, List<HRegionInfo>> clusterState = new HashMap<ServerName, List<HRegionInfo>>();
        ServerName serverA = (ServerName)servers.get(0);
        ServerName serverB = (ServerName)servers.get(1);
        ServerName serverC = (ServerName)servers.get(2);
        List<HRegionInfo> regionsOnServerA = this.randomRegions(3);
        List<HRegionInfo> regionsOnServerB = this.randomRegions(3);
        List<HRegionInfo> regionsOnServerC = this.randomRegions(3);
        clusterState.put(serverA, regionsOnServerA);
        clusterState.put(serverB, regionsOnServerB);
        clusterState.put(serverC, regionsOnServerC);
        final TreeMap<ServerName, ServerLoad> serverMetricsMap = new TreeMap<ServerName, ServerLoad>();
        serverMetricsMap.put(serverA, this.mockServerLoadWithReadRequests(serverA, regionsOnServerA, 0L));
        serverMetricsMap.put(serverB, this.mockServerLoadWithReadRequests(serverB, regionsOnServerB, 0L));
        serverMetricsMap.put(serverC, this.mockServerLoadWithReadRequests(serverC, regionsOnServerC, 0L));
        ClusterStatus clusterStatus = (ClusterStatus)Mockito.mock(ClusterStatus.class);
        Mockito.when((Object)clusterStatus.getServers()).thenReturn(serverMetricsMap.keySet());
        Mockito.when((Object)clusterStatus.getLoad((ServerName)Mockito.any(ServerName.class))).thenAnswer((Answer)new Answer<ServerLoad>(){

            public ServerLoad answer(InvocationOnMock invocation) throws Throwable {
                return (ServerLoad)serverMetricsMap.get(invocation.getArguments()[0]);
            }
        });
        loadBalancer.setClusterStatus(clusterStatus);
        final TreeMap<ServerName, ServerLoad> serverMetricsMap2 = new TreeMap<ServerName, ServerLoad>();
        serverMetricsMap2.put(serverA, this.mockServerLoadWithReadRequests(serverA, regionsOnServerA, 1000L));
        serverMetricsMap2.put(serverB, this.mockServerLoadWithReadRequests(serverB, regionsOnServerB, 0L));
        serverMetricsMap2.put(serverC, this.mockServerLoadWithReadRequests(serverC, regionsOnServerC, 0L));
        clusterStatus = (ClusterStatus)Mockito.mock(ClusterStatus.class);
        Mockito.when((Object)clusterStatus.getServers()).thenReturn(serverMetricsMap2.keySet());
        Mockito.when((Object)clusterStatus.getLoad((ServerName)Mockito.any(ServerName.class))).thenAnswer((Answer)new Answer<ServerLoad>(){

            public ServerLoad answer(InvocationOnMock invocation) throws Throwable {
                return (ServerLoad)serverMetricsMap2.get(invocation.getArguments()[0]);
            }
        });
        loadBalancer.setClusterStatus(clusterStatus);
        List plans = loadBalancer.balanceCluster(clusterState);
        HashSet<HRegionInfo> regionsMoveFromServerA = new HashSet<HRegionInfo>();
        HashSet<ServerName> targetServers = new HashSet<ServerName>();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)serverA)) continue;
            regionsMoveFromServerA.add(plan.getRegionInfo());
            targetServers.add(plan.getDestination());
        }
        Assert.assertEquals((long)2L, (long)regionsMoveFromServerA.size());
        Assert.assertEquals((long)2L, (long)targetServers.size());
        Assert.assertTrue((boolean)regionsOnServerA.containsAll(regionsMoveFromServerA));
    }
}

