/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestRSGroupsWithACL
extends SecureTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsWithACL.class);
    private static TableName TEST_TABLE = TableName.valueOf((String)"testtable1");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static Connection systemUserConnection;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static byte[] TEST_FAMILY;
    private static RSGroupAdminEndpoint rsGroupAdminEndpoint;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TestRSGroupsWithACL.enableSecurity((Configuration)conf);
        TestRSGroupsWithACL.verifyConfiguration((Configuration)conf);
        TestRSGroupsWithACL.configureRSGroupAdminEndpoint(conf);
        TEST_UTIL.startMiniCluster();
        rsGroupAdminEndpoint = (RSGroupAdminEndpoint)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(RSGroupAdminEndpoint.class.getName());
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting((Configuration)conf, (String)"user_group_create", (String[])new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting((Configuration)conf, (String)"user_group_read", (String[])new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting((Configuration)conf, (String)"user_group_write", (String[])new String[]{GROUP_WRITE});
        systemUserConnection = TEST_UTIL.getConnection();
        TestRSGroupsWithACL.setUpTableAndUserPermissions();
    }

    private static void setUpTableAndUserPermissions() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        TestRSGroupsWithACL.createTable((HBaseTestingUtility)TEST_UTIL, (HTableDescriptor)htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TestRSGroupsWithACL.grantGlobal((HBaseTestingUtility)TEST_UTIL, (String)USER_ADMIN.getShortName(), (Permission.Action[])new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE});
        TestRSGroupsWithACL.grantOnTable((HBaseTestingUtility)TEST_UTIL, (String)USER_RW.getShortName(), (TableName)TEST_TABLE, (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
        TestRSGroupsWithACL.grantOnTable((HBaseTestingUtility)TEST_UTIL, (String)USER_CREATE.getShortName(), (TableName)TEST_TABLE, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE});
        TestRSGroupsWithACL.grantOnTable((HBaseTestingUtility)TEST_UTIL, (String)USER_RO.getShortName(), (TableName)TEST_TABLE, (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        TestRSGroupsWithACL.grantGlobal((HBaseTestingUtility)TEST_UTIL, (String)AuthUtil.toGroupEntry((String)GROUP_ADMIN), (Permission.Action[])new Permission.Action[]{Permission.Action.ADMIN});
        TestRSGroupsWithACL.grantGlobal((HBaseTestingUtility)TEST_UTIL, (String)AuthUtil.toGroupEntry((String)GROUP_CREATE), (Permission.Action[])new Permission.Action[]{Permission.Action.CREATE});
        TestRSGroupsWithACL.grantGlobal((HBaseTestingUtility)TEST_UTIL, (String)AuthUtil.toGroupEntry((String)GROUP_READ), (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        TestRSGroupsWithACL.grantGlobal((HBaseTestingUtility)TEST_UTIL, (String)AuthUtil.toGroupEntry((String)GROUP_WRITE), (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
        Assert.assertEquals((long)4L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        try {
            Assert.assertEquals((long)4L, (long)AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)TEST_TABLE.toString()).size());
        }
        catch (Throwable e) {
            LOG.error("error during call of AccessControlClient.getUserPermissions. ", e);
        }
    }

    private static void cleanUp() throws Exception {
        try {
            TestRSGroupsWithACL.deleteTable((HBaseTestingUtility)TEST_UTIL, (TableName)TEST_TABLE);
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + TEST_TABLE);
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_TABLE.getNamespaceAsString()).size());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestRSGroupsWithACL.cleanUp();
        TEST_UTIL.shutdownMiniCluster();
        int total = TableAuthManager.getTotalRefCount();
        Assert.assertTrue((String)("Unexpected reference count: " + total), (total == 0 ? 1 : 0) != 0);
    }

    private static void configureRSGroupAdminEndpoint(Configuration conf) {
        String currentCoprocessors = conf.get("hbase.coprocessor.master.classes");
        Object coprocessors = RSGroupAdminEndpoint.class.getName();
        if (currentCoprocessors != null) {
            coprocessors = (String)coprocessors + "," + currentCoprocessors;
        }
        conf.set("hbase.coprocessor.master.classes", (String)coprocessors);
        conf.set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
    }

    @Test
    public void testGetRSGroupInfo() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("getRSGroupInfo");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testGetRSGroupInfoOfTable() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("getRSGroupInfoOfTable");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testMoveServers() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("moveServers");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testMoveTables() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("moveTables");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testAddRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("addRSGroup");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testRemoveRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("removeRSGroup");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testBalanceRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("balanceRSGroup");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testListRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("listRSGroup");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testGetRSGroupInfoOfServer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("getRSGroupInfoOfServer");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    @Test
    public void testMoveServersAndTables() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            public Object run() throws Exception {
                rsGroupAdminEndpoint.checkPermission("moveServersAndTables");
                return null;
            }
        };
        TestRSGroupsWithACL.verifyAllowed((SecureTestUtil.AccessTestAction)action, (User[])new User[]{SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN});
        TestRSGroupsWithACL.verifyDenied((SecureTestUtil.AccessTestAction)action, (User[])new User[]{USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE});
    }

    static {
        TEST_FAMILY = Bytes.toBytes((String)"f1");
    }
}

