/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableRegionModel
extends TestModelBase<TableRegionModel> {
    private static final String TABLE = "testtable";
    private static final byte[] START_KEY = Bytes.toBytes((String)"abracadbra");
    private static final byte[] END_KEY = Bytes.toBytes((String)"zzyzx");
    private static final long ID = 8731042424L;
    private static final String LOCATION = "testhost:9876";

    public TestTableRegionModel() throws Exception {
        super(TableRegionModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Region endKey=\"enp5eng=\" id=\"8731042424\" location=\"testhost:9876\" name=\"testtable,abracadbra,8731042424.ad9860f031282c46ed431d7af8f94aca.\" startKey=\"YWJyYWNhZGJyYQ==\"/>";
        this.AS_JSON = "{\"endKey\":\"enp5eng=\",\"id\":8731042424,\"location\":\"testhost:9876\",\"name\":\"testtable,abracadbra,8731042424.ad9860f031282c46ed431d7af8f94aca.\",\"startKey\":\"YWJyYWNhZGJyYQ==\"}";
    }

    @Override
    protected TableRegionModel buildTestModel() {
        TableRegionModel model = new TableRegionModel(TABLE, 8731042424L, START_KEY, END_KEY, LOCATION);
        return model;
    }

    @Override
    protected void checkModel(TableRegionModel model) {
        TestTableRegionModel.assertTrue((boolean)Bytes.equals((byte[])model.getStartKey(), (byte[])START_KEY));
        TestTableRegionModel.assertTrue((boolean)Bytes.equals((byte[])model.getEndKey(), (byte[])END_KEY));
        TestTableRegionModel.assertEquals((long)8731042424L, (long)model.getId());
        TestTableRegionModel.assertEquals((String)LOCATION, (String)model.getLocation());
        TestTableRegionModel.assertEquals((String)("testtable," + Bytes.toString((byte[])START_KEY) + "," + Long.toString(8731042424L) + ".ad9860f031282c46ed431d7af8f94aca."), (String)model.getName());
    }

    public void testGetName() {
        TableRegionModel model = this.buildTestModel();
        String modelName = model.getName();
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)TABLE), START_KEY, END_KEY, false, 8731042424L);
        TestTableRegionModel.assertEquals((String)modelName, (String)hri.getRegionNameAsString());
    }

    public void testSetName() {
        TableRegionModel model = this.buildTestModel();
        String name = model.getName();
        model.setName(name);
        TestTableRegionModel.assertEquals((String)name, (String)model.getName());
    }

    @Override
    public void testFromPB() throws Exception {
    }
}

