/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.rest.model.NamespacesInstanceModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestNamespacesInstanceModel
extends TestModelBase<NamespacesInstanceModel> {
    public static final Map<String, String> NAMESPACE_PROPERTIES = new HashMap<String, String>();
    public static final String NAMESPACE_NAME = "namespaceName";

    public TestNamespacesInstanceModel() throws Exception {
        super(NamespacesInstanceModel.class);
        NAMESPACE_PROPERTIES.put("KEY_1", "VALUE_1");
        NAMESPACE_PROPERTIES.put("KEY_2", "VALUE_2");
        NAMESPACE_PROPERTIES.put("NAME", "testNamespace");
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><NamespaceProperties><properties><entry><key>NAME</key><value>testNamespace</value></entry><entry><key>KEY_2</key><value>VALUE_2</value></entry><entry><key>KEY_1</key><value>VALUE_1</value></entry></properties></NamespaceProperties>";
        this.AS_PB = "ChUKBE5BTUUSDXRlc3ROYW1lc3BhY2UKEAoFS0VZXzESB1ZBTFVFXzEKEAoFS0VZXzISB1ZBTFVFXzI=";
        this.AS_JSON = "{\"properties\":{\"NAME\":\"testNamespace\",\"KEY_1\":\"VALUE_1\",\"KEY_2\":\"VALUE_2\"}}";
    }

    @Override
    protected NamespacesInstanceModel buildTestModel() {
        return this.buildTestModel(NAMESPACE_NAME, NAMESPACE_PROPERTIES);
    }

    public NamespacesInstanceModel buildTestModel(String namespace, Map<String, String> properties) {
        NamespacesInstanceModel model = new NamespacesInstanceModel();
        for (String key : properties.keySet()) {
            model.addProperty(key, properties.get(key));
        }
        return model;
    }

    @Override
    protected void checkModel(NamespacesInstanceModel model) {
        this.checkModel(model, NAMESPACE_NAME, NAMESPACE_PROPERTIES);
    }

    public void checkModel(NamespacesInstanceModel model, String namespace, Map<String, String> properties) {
        Map modProperties = model.getProperties();
        TestNamespacesInstanceModel.assertEquals((int)properties.size(), (int)modProperties.size());
        TestNamespacesInstanceModel.assertNotSame((Object)namespace, (Object)model.getNamespaceName());
        for (String property : properties.keySet()) {
            TestNamespacesInstanceModel.assertEquals((String)properties.get(property), (String)((String)modProperties.get(property)));
        }
    }

    @Override
    @Test
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    @Test
    public void testFromXML() throws Exception {
        this.checkModel((NamespacesInstanceModel)this.fromXML(this.AS_XML));
    }

    @Override
    @Test
    public void testFromPB() throws Exception {
        this.checkModel((NamespacesInstanceModel)this.fromPB(this.AS_PB));
    }
}

