/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;

@InterfaceAudience.Private
public class RowResultGenerator
extends ResultGenerator {
    private static final Log LOG = LogFactory.getLog(RowResultGenerator.class);
    private Iterator<Cell> valuesI;
    private Cell cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowResultGenerator(String tableName, RowSpec rowspec, Filter filter, boolean cacheBlocks) throws IllegalArgumentException, IOException {
        try (Table table = RESTServlet.getInstance().getTable(tableName);){
            Get get = new Get(rowspec.getRow());
            if (rowspec.hasColumns()) {
                for (byte[] col : rowspec.getColumns()) {
                    byte[][] split = KeyValue.parseColumn((byte[])col);
                    if (split.length == 1) {
                        get.addFamily(split[0]);
                        continue;
                    }
                    if (split.length == 2) {
                        get.addColumn(split[0], split[1]);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid column specifier.");
                }
            }
            get.setTimeRange(rowspec.getStartTime(), rowspec.getEndTime());
            get.setMaxVersions(rowspec.getMaxVersions());
            if (filter != null) {
                get.setFilter(filter);
            }
            get.setCacheBlocks(cacheBlocks);
            Result result = table.get(get);
            if (result != null && !result.isEmpty()) {
                this.valuesI = result.listCells().iterator();
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.cache != null) {
            return true;
        }
        if (this.valuesI == null) {
            return false;
        }
        return this.valuesI.hasNext();
    }

    @Override
    public Cell next() {
        if (this.cache != null) {
            Cell kv = this.cache;
            this.cache = null;
            return kv;
        }
        if (this.valuesI == null) {
            return null;
        }
        try {
            return this.valuesI.next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public void putBack(Cell kv) {
        this.cache = kv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

