/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Response {
    private int code;
    private Header[] headers;
    private byte[] body;
    private HttpResponse resp;
    private InputStream stream;
    public static final Log LOG = LogFactory.getLog(Response.class);

    public Response(int code) {
        this(code, null, null);
    }

    public Response(int code, Header[] headers) {
        this(code, headers, null);
    }

    public Response(int code, Header[] headers, byte[] body) {
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    public Response(int code, Header[] headers, HttpResponse resp, InputStream in) {
        this.code = code;
        this.headers = headers;
        this.body = null;
        this.resp = resp;
        this.stream = in;
    }

    public int getCode() {
        return this.code;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(key)) continue;
            return header.getValue();
        }
        return null;
    }

    public String getLocation() {
        return this.getHeader("Location");
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public byte[] getBody() {
        if (this.body == null) {
            try {
                this.body = Client.getResponseBody(this.resp);
            }
            catch (IOException ioe) {
                LOG.debug((Object)"encountered ioe when obtaining body", (Throwable)ioe);
            }
        }
        return this.body;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

