/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestStorageClusterStatusModel
extends TestModelBase<StorageClusterStatusModel> {
    public TestStorageClusterStatusModel() throws Exception {
        super(StorageClusterStatusModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ClusterStatus averageLoad=\"1.0\" regions=\"2\" requests=\"0\"><DeadNodes/><LiveNodes><Node heapSizeMB=\"128\" maxHeapSizeMB=\"1024\" name=\"test1\" requests=\"0\" startCode=\"1245219839331\"><Region currentCompactedKVs=\"1\" memstoreSizeMB=\"0\" name=\"aGJhc2U6cm9vdCwsMA==\" readRequestsCount=\"1\" rootIndexSizeKB=\"1\" storefileIndexSizeMB=\"0\" storefileSizeMB=\"0\" storefiles=\"1\" stores=\"1\" totalCompactingKVs=\"1\" totalStaticBloomSizeKB=\"1\" totalStaticIndexSizeKB=\"1\" writeRequestsCount=\"2\"/></Node><Node heapSizeMB=\"512\" maxHeapSizeMB=\"1024\" name=\"test2\" requests=\"0\" startCode=\"1245239331198\"><Region currentCompactedKVs=\"1\" memstoreSizeMB=\"0\" name=\"aGJhc2U6bWV0YSwsMTI0NjAwMDA0MzcyNA==\" readRequestsCount=\"1\" rootIndexSizeKB=\"1\" storefileIndexSizeMB=\"0\" storefileSizeMB=\"0\" storefiles=\"1\" stores=\"1\" totalCompactingKVs=\"1\" totalStaticBloomSizeKB=\"1\" totalStaticIndexSizeKB=\"1\" writeRequestsCount=\"2\"/></Node></LiveNodes></ClusterStatus>";
        this.AS_PB = "Cj8KBXRlc3QxEOO6i+eeJBgAIIABKIAIMicKDWhiYXNlOnJvb3QsLDAQARgBIAAoADAAOAFAAkgBUAFYAWABaAEKSwoFdGVzdDIQ/pKx8J4kGAAggAQogAgyMwoZaGJhc2U6bWV0YSwsMTI0NjAwMDA0MzcyNBABGAEgACgAMAA4AUACSAFQAVgBYAFoARgCIAApAAAAAAAA8D8=";
        this.AS_JSON = "{\"regions\":2,\"requests\":0,\"averageLoad\":1.0,\"LiveNodes\":[{\"name\":\"test1\",\"Region\":[{\"name\":\"aGJhc2U6cm9vdCwsMA==\",\"stores\":1,\"storefiles\":1,\"storefileSizeMB\":0,\"memstoreSizeMB\":0,\"storefileIndexSizeMB\":0,\"readRequestsCount\":1,\"writeRequestsCount\":2,\"rootIndexSizeKB\":1,\"totalStaticIndexSizeKB\":1,\"totalStaticBloomSizeKB\":1,\"totalCompactingKVs\":1,\"currentCompactedKVs\":1}],\"requests\":0,\"startCode\":1245219839331,\"heapSizeMB\":128,\"maxHeapSizeMB\":1024},{\"name\":\"test2\",\"Region\":[{\"name\":\"aGJhc2U6bWV0YSwsMTI0NjAwMDA0MzcyNA==\",\"stores\":1,\"storefiles\":1,\"storefileSizeMB\":0,\"memstoreSizeMB\":0,\"storefileIndexSizeMB\":0,\"readRequestsCount\":1,\"writeRequestsCount\":2,\"rootIndexSizeKB\":1,\"totalStaticIndexSizeKB\":1,\"totalStaticBloomSizeKB\":1,\"totalCompactingKVs\":1,\"currentCompactedKVs\":1}],\"requests\":0,\"startCode\":1245239331198,\"heapSizeMB\":512,\"maxHeapSizeMB\":1024}],\"DeadNodes\":[]}";
    }

    @Override
    protected StorageClusterStatusModel buildTestModel() {
        StorageClusterStatusModel model = new StorageClusterStatusModel();
        model.setRegions(2);
        model.setRequests(0);
        model.setAverageLoad(1.0);
        model.addLiveNode("test1", 1245219839331L, 128, 1024).addRegion(Bytes.toBytes((String)"hbase:root,,0"), 1, 1, 0, 0, 0, 1L, 2L, 1, 1, 1, 1L, 1L);
        model.addLiveNode("test2", 1245239331198L, 512, 1024).addRegion(Bytes.toBytes((String)(TableName.META_TABLE_NAME + ",,1246000043724")), 1, 1, 0, 0, 0, 1L, 2L, 1, 1, 1, 1L, 1L);
        return model;
    }

    @Override
    protected void checkModel(StorageClusterStatusModel model) {
        TestStorageClusterStatusModel.assertEquals((int)2, (int)model.getRegions());
        TestStorageClusterStatusModel.assertEquals((long)0L, (long)model.getRequests());
        TestStorageClusterStatusModel.assertEquals((double)1.0, (double)model.getAverageLoad(), (double)0.0);
        Iterator nodes = model.getLiveNodes().iterator();
        StorageClusterStatusModel.Node node = (StorageClusterStatusModel.Node)nodes.next();
        TestStorageClusterStatusModel.assertEquals((String)"test1", (String)node.getName());
        TestStorageClusterStatusModel.assertEquals((long)1245219839331L, (long)node.getStartCode());
        TestStorageClusterStatusModel.assertEquals((int)128, (int)node.getHeapSizeMB());
        TestStorageClusterStatusModel.assertEquals((int)1024, (int)node.getMaxHeapSizeMB());
        Iterator regions = node.getRegions().iterator();
        StorageClusterStatusModel.Node.Region region = (StorageClusterStatusModel.Node.Region)regions.next();
        TestStorageClusterStatusModel.assertTrue((boolean)Bytes.toString((byte[])region.getName()).equals("hbase:root,,0"));
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getStores());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getStorefiles());
        TestStorageClusterStatusModel.assertEquals((int)0, (int)region.getStorefileSizeMB());
        TestStorageClusterStatusModel.assertEquals((int)0, (int)region.getMemstoreSizeMB());
        TestStorageClusterStatusModel.assertEquals((int)0, (int)region.getStorefileIndexSizeMB());
        TestStorageClusterStatusModel.assertEquals((long)1L, (long)region.getReadRequestsCount());
        TestStorageClusterStatusModel.assertEquals((long)2L, (long)region.getWriteRequestsCount());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getRootIndexSizeKB());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getTotalStaticIndexSizeKB());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getTotalStaticBloomSizeKB());
        TestStorageClusterStatusModel.assertEquals((long)1L, (long)region.getTotalCompactingKVs());
        TestStorageClusterStatusModel.assertEquals((long)1L, (long)region.getCurrentCompactedKVs());
        TestStorageClusterStatusModel.assertFalse((boolean)regions.hasNext());
        node = (StorageClusterStatusModel.Node)nodes.next();
        TestStorageClusterStatusModel.assertEquals((String)"test2", (String)node.getName());
        TestStorageClusterStatusModel.assertEquals((long)1245239331198L, (long)node.getStartCode());
        TestStorageClusterStatusModel.assertEquals((int)512, (int)node.getHeapSizeMB());
        TestStorageClusterStatusModel.assertEquals((int)1024, (int)node.getMaxHeapSizeMB());
        regions = node.getRegions().iterator();
        region = (StorageClusterStatusModel.Node.Region)regions.next();
        TestStorageClusterStatusModel.assertEquals((String)Bytes.toString((byte[])region.getName()), (String)(TableName.META_TABLE_NAME + ",,1246000043724"));
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getStores());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getStorefiles());
        TestStorageClusterStatusModel.assertEquals((int)0, (int)region.getStorefileSizeMB());
        TestStorageClusterStatusModel.assertEquals((int)0, (int)region.getMemstoreSizeMB());
        TestStorageClusterStatusModel.assertEquals((int)0, (int)region.getStorefileIndexSizeMB());
        TestStorageClusterStatusModel.assertEquals((long)1L, (long)region.getReadRequestsCount());
        TestStorageClusterStatusModel.assertEquals((long)2L, (long)region.getWriteRequestsCount());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getRootIndexSizeKB());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getTotalStaticIndexSizeKB());
        TestStorageClusterStatusModel.assertEquals((int)1, (int)region.getTotalStaticBloomSizeKB());
        TestStorageClusterStatusModel.assertEquals((long)1L, (long)region.getTotalCompactingKVs());
        TestStorageClusterStatusModel.assertEquals((long)1L, (long)region.getCurrentCompactedKVs());
        TestStorageClusterStatusModel.assertFalse((boolean)regions.hasNext());
        TestStorageClusterStatusModel.assertFalse((boolean)nodes.hasNext());
    }
}

