/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.LongEncoder;
import org.apache.hadoop.hbase.util.vint.UVIntTool;
import org.apache.hadoop.hbase.util.vint.UVLongTool;

@InterfaceAudience.Private
public class PrefixTreeBlockMeta {
    public static final int VERSION = 0;
    public static final int MAX_FAMILY_LENGTH = 127;
    public static final int NUM_LONGS = 2;
    public static final int NUM_INTS = 28;
    public static final int NUM_SHORTS = 0;
    public static final int NUM_SINGLE_BYTES = 2;
    public static final int MAX_BYTES = 130;
    protected int arrayOffset;
    protected int bufferOffset;
    protected int version;
    protected int numMetaBytes;
    protected int numKeyValueBytes;
    protected boolean includesMvccVersion;
    protected int numRowBytes;
    protected int numFamilyBytes;
    protected int numQualifierBytes;
    protected int numTimestampBytes;
    protected int numMvccVersionBytes;
    protected int numValueBytes;
    protected int numTagsBytes;
    protected int nextNodeOffsetWidth;
    protected int familyOffsetWidth;
    protected int qualifierOffsetWidth;
    protected int timestampIndexWidth;
    protected int mvccVersionIndexWidth;
    protected int valueOffsetWidth;
    protected int valueLengthWidth;
    protected int tagsOffsetWidth;
    protected int rowTreeDepth;
    protected int maxRowLength;
    protected int maxQualifierLength;
    protected int maxTagsLength;
    protected long minTimestamp;
    protected int timestampDeltaWidth;
    protected long minMvccVersion;
    protected int mvccVersionDeltaWidth;
    protected boolean allSameType;
    protected byte allTypes;
    protected int numUniqueRows;
    protected int numUniqueFamilies;
    protected int numUniqueQualifiers;
    protected int numUniqueTags;

    public PrefixTreeBlockMeta() {
    }

    public PrefixTreeBlockMeta(InputStream is) throws IOException {
        this.version = 0;
        this.arrayOffset = 0;
        this.bufferOffset = 0;
        this.readVariableBytesFromInputStream(is);
    }

    public PrefixTreeBlockMeta(ByteBuffer buffer) {
        this.initOnBlock(buffer);
    }

    public void initOnBlock(ByteBuffer buffer) {
        this.arrayOffset = buffer.arrayOffset();
        this.bufferOffset = buffer.position();
        this.readVariableBytesFromArray(buffer.array(), this.arrayOffset + this.bufferOffset);
    }

    public int calculateNumMetaBytes() {
        int numBytes = 0;
        numBytes += UVIntTool.numBytes(this.version);
        numBytes += UVLongTool.numBytes(this.numMetaBytes);
        numBytes += UVIntTool.numBytes(this.numKeyValueBytes);
        ++numBytes;
        numBytes += UVIntTool.numBytes(this.numRowBytes);
        numBytes += UVIntTool.numBytes(this.numFamilyBytes);
        numBytes += UVIntTool.numBytes(this.numQualifierBytes);
        numBytes += UVIntTool.numBytes(this.numTagsBytes);
        numBytes += UVIntTool.numBytes(this.numTimestampBytes);
        numBytes += UVIntTool.numBytes(this.numMvccVersionBytes);
        numBytes += UVIntTool.numBytes(this.numValueBytes);
        numBytes += UVIntTool.numBytes(this.nextNodeOffsetWidth);
        numBytes += UVIntTool.numBytes(this.familyOffsetWidth);
        numBytes += UVIntTool.numBytes(this.qualifierOffsetWidth);
        numBytes += UVIntTool.numBytes(this.tagsOffsetWidth);
        numBytes += UVIntTool.numBytes(this.timestampIndexWidth);
        numBytes += UVIntTool.numBytes(this.mvccVersionIndexWidth);
        numBytes += UVIntTool.numBytes(this.valueOffsetWidth);
        numBytes += UVIntTool.numBytes(this.valueLengthWidth);
        numBytes += UVIntTool.numBytes(this.rowTreeDepth);
        numBytes += UVIntTool.numBytes(this.maxRowLength);
        numBytes += UVIntTool.numBytes(this.maxQualifierLength);
        numBytes += UVIntTool.numBytes(this.maxTagsLength);
        numBytes += UVLongTool.numBytes(this.minTimestamp);
        numBytes += UVIntTool.numBytes(this.timestampDeltaWidth);
        numBytes += UVLongTool.numBytes(this.minMvccVersion);
        numBytes += UVIntTool.numBytes(this.mvccVersionDeltaWidth);
        ++numBytes;
        ++numBytes;
        numBytes += UVIntTool.numBytes(this.numUniqueRows);
        numBytes += UVIntTool.numBytes(this.numUniqueFamilies);
        numBytes += UVIntTool.numBytes(this.numUniqueQualifiers);
        return numBytes += UVIntTool.numBytes(this.numUniqueTags);
    }

    public void writeVariableBytesToOutputStream(OutputStream os) throws IOException {
        UVIntTool.writeBytes(this.version, os);
        UVIntTool.writeBytes(this.numMetaBytes, os);
        UVIntTool.writeBytes(this.numKeyValueBytes, os);
        os.write(this.getIncludesMvccVersionByte());
        UVIntTool.writeBytes(this.numRowBytes, os);
        UVIntTool.writeBytes(this.numFamilyBytes, os);
        UVIntTool.writeBytes(this.numQualifierBytes, os);
        UVIntTool.writeBytes(this.numTagsBytes, os);
        UVIntTool.writeBytes(this.numTimestampBytes, os);
        UVIntTool.writeBytes(this.numMvccVersionBytes, os);
        UVIntTool.writeBytes(this.numValueBytes, os);
        UVIntTool.writeBytes(this.nextNodeOffsetWidth, os);
        UVIntTool.writeBytes(this.familyOffsetWidth, os);
        UVIntTool.writeBytes(this.qualifierOffsetWidth, os);
        UVIntTool.writeBytes(this.tagsOffsetWidth, os);
        UVIntTool.writeBytes(this.timestampIndexWidth, os);
        UVIntTool.writeBytes(this.mvccVersionIndexWidth, os);
        UVIntTool.writeBytes(this.valueOffsetWidth, os);
        UVIntTool.writeBytes(this.valueLengthWidth, os);
        UVIntTool.writeBytes(this.rowTreeDepth, os);
        UVIntTool.writeBytes(this.maxRowLength, os);
        UVIntTool.writeBytes(this.maxQualifierLength, os);
        UVIntTool.writeBytes(this.maxTagsLength, os);
        UVLongTool.writeBytes(this.minTimestamp, os);
        UVIntTool.writeBytes(this.timestampDeltaWidth, os);
        UVLongTool.writeBytes(this.minMvccVersion, os);
        UVIntTool.writeBytes(this.mvccVersionDeltaWidth, os);
        os.write(this.getAllSameTypeByte());
        os.write(this.allTypes);
        UVIntTool.writeBytes(this.numUniqueRows, os);
        UVIntTool.writeBytes(this.numUniqueFamilies, os);
        UVIntTool.writeBytes(this.numUniqueQualifiers, os);
        UVIntTool.writeBytes(this.numUniqueTags, os);
    }

    public void readVariableBytesFromInputStream(InputStream is) throws IOException {
        this.version = UVIntTool.getInt(is);
        this.numMetaBytes = UVIntTool.getInt(is);
        this.numKeyValueBytes = UVIntTool.getInt(is);
        this.setIncludesMvccVersion((byte)is.read());
        this.numRowBytes = UVIntTool.getInt(is);
        this.numFamilyBytes = UVIntTool.getInt(is);
        this.numQualifierBytes = UVIntTool.getInt(is);
        this.numTagsBytes = UVIntTool.getInt(is);
        this.numTimestampBytes = UVIntTool.getInt(is);
        this.numMvccVersionBytes = UVIntTool.getInt(is);
        this.numValueBytes = UVIntTool.getInt(is);
        this.nextNodeOffsetWidth = UVIntTool.getInt(is);
        this.familyOffsetWidth = UVIntTool.getInt(is);
        this.qualifierOffsetWidth = UVIntTool.getInt(is);
        this.tagsOffsetWidth = UVIntTool.getInt(is);
        this.timestampIndexWidth = UVIntTool.getInt(is);
        this.mvccVersionIndexWidth = UVIntTool.getInt(is);
        this.valueOffsetWidth = UVIntTool.getInt(is);
        this.valueLengthWidth = UVIntTool.getInt(is);
        this.rowTreeDepth = UVIntTool.getInt(is);
        this.maxRowLength = UVIntTool.getInt(is);
        this.maxQualifierLength = UVIntTool.getInt(is);
        this.maxTagsLength = UVIntTool.getInt(is);
        this.minTimestamp = UVLongTool.getLong(is);
        this.timestampDeltaWidth = UVIntTool.getInt(is);
        this.minMvccVersion = UVLongTool.getLong(is);
        this.mvccVersionDeltaWidth = UVIntTool.getInt(is);
        this.setAllSameType((byte)is.read());
        this.allTypes = (byte)is.read();
        this.numUniqueRows = UVIntTool.getInt(is);
        this.numUniqueFamilies = UVIntTool.getInt(is);
        this.numUniqueQualifiers = UVIntTool.getInt(is);
        this.numUniqueTags = UVIntTool.getInt(is);
    }

    public void readVariableBytesFromArray(byte[] bytes, int offset) {
        int position = offset;
        this.version = UVIntTool.getInt(bytes, position);
        this.numMetaBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.version));
        this.numKeyValueBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numMetaBytes));
        this.setIncludesMvccVersion(bytes[position += UVIntTool.numBytes(this.numKeyValueBytes)]);
        this.numRowBytes = UVIntTool.getInt(bytes, ++position);
        this.numFamilyBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numRowBytes));
        this.numQualifierBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numFamilyBytes));
        this.numTagsBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numQualifierBytes));
        this.numTimestampBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numTagsBytes));
        this.numMvccVersionBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numTimestampBytes));
        this.numValueBytes = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numMvccVersionBytes));
        this.nextNodeOffsetWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numValueBytes));
        this.familyOffsetWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.nextNodeOffsetWidth));
        this.qualifierOffsetWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.familyOffsetWidth));
        this.tagsOffsetWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.qualifierOffsetWidth));
        this.timestampIndexWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.tagsOffsetWidth));
        this.mvccVersionIndexWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.timestampIndexWidth));
        this.valueOffsetWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.mvccVersionIndexWidth));
        this.valueLengthWidth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.valueOffsetWidth));
        this.rowTreeDepth = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.valueLengthWidth));
        this.maxRowLength = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.rowTreeDepth));
        this.maxQualifierLength = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.maxRowLength));
        this.maxTagsLength = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.maxQualifierLength));
        this.minTimestamp = UVLongTool.getLong(bytes, position += UVIntTool.numBytes(this.maxTagsLength));
        this.timestampDeltaWidth = UVIntTool.getInt(bytes, position += UVLongTool.numBytes(this.minTimestamp));
        this.minMvccVersion = UVLongTool.getLong(bytes, position += UVIntTool.numBytes(this.timestampDeltaWidth));
        this.mvccVersionDeltaWidth = UVIntTool.getInt(bytes, position += UVLongTool.numBytes(this.minMvccVersion));
        this.setAllSameType(bytes[position += UVIntTool.numBytes(this.mvccVersionDeltaWidth)]);
        this.allTypes = bytes[++position];
        this.numUniqueRows = UVIntTool.getInt(bytes, ++position);
        this.numUniqueFamilies = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numUniqueRows));
        this.numUniqueQualifiers = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numUniqueFamilies));
        this.numUniqueTags = UVIntTool.getInt(bytes, position += UVIntTool.numBytes(this.numUniqueQualifiers));
        position += UVIntTool.numBytes(this.numUniqueTags);
    }

    public int getKeyValueTypeWidth() {
        return this.allSameType ? 0 : 1;
    }

    public byte getIncludesMvccVersionByte() {
        return this.includesMvccVersion ? (byte)1 : 0;
    }

    public void setIncludesMvccVersion(byte includesMvccVersionByte) {
        this.includesMvccVersion = includesMvccVersionByte != 0;
    }

    public byte getAllSameTypeByte() {
        return this.allSameType ? (byte)1 : 0;
    }

    public void setAllSameType(byte allSameTypeByte) {
        this.allSameType = allSameTypeByte != 0;
    }

    public boolean isAllSameTimestamp() {
        return this.timestampIndexWidth == 0;
    }

    public boolean isAllSameMvccVersion() {
        return this.mvccVersionIndexWidth == 0;
    }

    public void setTimestampFields(LongEncoder encoder) {
        this.minTimestamp = encoder.getMin();
        this.timestampIndexWidth = encoder.getBytesPerIndex();
        this.timestampDeltaWidth = encoder.getBytesPerDelta();
        this.numTimestampBytes = encoder.getTotalCompressedBytes();
    }

    public void setMvccVersionFields(LongEncoder encoder) {
        this.minMvccVersion = encoder.getMin();
        this.mvccVersionIndexWidth = encoder.getBytesPerIndex();
        this.mvccVersionDeltaWidth = encoder.getBytesPerDelta();
        this.numMvccVersionBytes = encoder.getTotalCompressedBytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixTreeBlockMeta other = (PrefixTreeBlockMeta)obj;
        if (this.allSameType != other.allSameType) {
            return false;
        }
        if (this.allTypes != other.allTypes) {
            return false;
        }
        if (this.arrayOffset != other.arrayOffset) {
            return false;
        }
        if (this.bufferOffset != other.bufferOffset) {
            return false;
        }
        if (this.valueLengthWidth != other.valueLengthWidth) {
            return false;
        }
        if (this.valueOffsetWidth != other.valueOffsetWidth) {
            return false;
        }
        if (this.familyOffsetWidth != other.familyOffsetWidth) {
            return false;
        }
        if (this.includesMvccVersion != other.includesMvccVersion) {
            return false;
        }
        if (this.maxQualifierLength != other.maxQualifierLength) {
            return false;
        }
        if (this.maxTagsLength != other.maxTagsLength) {
            return false;
        }
        if (this.maxRowLength != other.maxRowLength) {
            return false;
        }
        if (this.mvccVersionDeltaWidth != other.mvccVersionDeltaWidth) {
            return false;
        }
        if (this.mvccVersionIndexWidth != other.mvccVersionIndexWidth) {
            return false;
        }
        if (this.minMvccVersion != other.minMvccVersion) {
            return false;
        }
        if (this.minTimestamp != other.minTimestamp) {
            return false;
        }
        if (this.nextNodeOffsetWidth != other.nextNodeOffsetWidth) {
            return false;
        }
        if (this.numValueBytes != other.numValueBytes) {
            return false;
        }
        if (this.numFamilyBytes != other.numFamilyBytes) {
            return false;
        }
        if (this.numMvccVersionBytes != other.numMvccVersionBytes) {
            return false;
        }
        if (this.numMetaBytes != other.numMetaBytes) {
            return false;
        }
        if (this.numQualifierBytes != other.numQualifierBytes) {
            return false;
        }
        if (this.numTagsBytes != other.numTagsBytes) {
            return false;
        }
        if (this.numRowBytes != other.numRowBytes) {
            return false;
        }
        if (this.numTimestampBytes != other.numTimestampBytes) {
            return false;
        }
        if (this.numUniqueFamilies != other.numUniqueFamilies) {
            return false;
        }
        if (this.numUniqueQualifiers != other.numUniqueQualifiers) {
            return false;
        }
        if (this.numUniqueTags != other.numUniqueTags) {
            return false;
        }
        if (this.numUniqueRows != other.numUniqueRows) {
            return false;
        }
        if (this.numKeyValueBytes != other.numKeyValueBytes) {
            return false;
        }
        if (this.qualifierOffsetWidth != other.qualifierOffsetWidth) {
            return false;
        }
        if (this.tagsOffsetWidth != other.tagsOffsetWidth) {
            return false;
        }
        if (this.rowTreeDepth != other.rowTreeDepth) {
            return false;
        }
        if (this.timestampDeltaWidth != other.timestampDeltaWidth) {
            return false;
        }
        if (this.timestampIndexWidth != other.timestampIndexWidth) {
            return false;
        }
        return this.version == other.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allSameType ? 1231 : 1237);
        result = 31 * result + this.allTypes;
        result = 31 * result + this.arrayOffset;
        result = 31 * result + this.bufferOffset;
        result = 31 * result + this.valueLengthWidth;
        result = 31 * result + this.valueOffsetWidth;
        result = 31 * result + this.familyOffsetWidth;
        result = 31 * result + (this.includesMvccVersion ? 1231 : 1237);
        result = 31 * result + this.maxQualifierLength;
        result = 31 * result + this.maxTagsLength;
        result = 31 * result + this.maxRowLength;
        result = 31 * result + this.mvccVersionDeltaWidth;
        result = 31 * result + this.mvccVersionIndexWidth;
        result = 31 * result + (int)(this.minMvccVersion ^ this.minMvccVersion >>> 32);
        result = 31 * result + (int)(this.minTimestamp ^ this.minTimestamp >>> 32);
        result = 31 * result + this.nextNodeOffsetWidth;
        result = 31 * result + this.numValueBytes;
        result = 31 * result + this.numFamilyBytes;
        result = 31 * result + this.numMvccVersionBytes;
        result = 31 * result + this.numMetaBytes;
        result = 31 * result + this.numQualifierBytes;
        result = 31 * result + this.numTagsBytes;
        result = 31 * result + this.numRowBytes;
        result = 31 * result + this.numTimestampBytes;
        result = 31 * result + this.numUniqueFamilies;
        result = 31 * result + this.numUniqueQualifiers;
        result = 31 * result + this.numUniqueTags;
        result = 31 * result + this.numUniqueRows;
        result = 31 * result + this.numKeyValueBytes;
        result = 31 * result + this.qualifierOffsetWidth;
        result = 31 * result + this.tagsOffsetWidth;
        result = 31 * result + this.rowTreeDepth;
        result = 31 * result + this.timestampDeltaWidth;
        result = 31 * result + this.timestampIndexWidth;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PtBlockMeta [arrayOffset=");
        builder.append(this.arrayOffset);
        builder.append(", bufferOffset=");
        builder.append(this.bufferOffset);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", numMetaBytes=");
        builder.append(this.numMetaBytes);
        builder.append(", numKeyValueBytes=");
        builder.append(this.numKeyValueBytes);
        builder.append(", includesMvccVersion=");
        builder.append(this.includesMvccVersion);
        builder.append(", numRowBytes=");
        builder.append(this.numRowBytes);
        builder.append(", numFamilyBytes=");
        builder.append(this.numFamilyBytes);
        builder.append(", numQualifierBytes=");
        builder.append(this.numQualifierBytes);
        builder.append(", numTimestampBytes=");
        builder.append(this.numTimestampBytes);
        builder.append(", numMvccVersionBytes=");
        builder.append(this.numMvccVersionBytes);
        builder.append(", numValueBytes=");
        builder.append(this.numValueBytes);
        builder.append(", numTagBytes=");
        builder.append(this.numTagsBytes);
        builder.append(", nextNodeOffsetWidth=");
        builder.append(this.nextNodeOffsetWidth);
        builder.append(", familyOffsetWidth=");
        builder.append(this.familyOffsetWidth);
        builder.append(", qualifierOffsetWidth=");
        builder.append(this.qualifierOffsetWidth);
        builder.append(", tagOffsetWidth=");
        builder.append(this.tagsOffsetWidth);
        builder.append(", timestampIndexWidth=");
        builder.append(this.timestampIndexWidth);
        builder.append(", mvccVersionIndexWidth=");
        builder.append(this.mvccVersionIndexWidth);
        builder.append(", valueOffsetWidth=");
        builder.append(this.valueOffsetWidth);
        builder.append(", valueLengthWidth=");
        builder.append(this.valueLengthWidth);
        builder.append(", rowTreeDepth=");
        builder.append(this.rowTreeDepth);
        builder.append(", maxRowLength=");
        builder.append(this.maxRowLength);
        builder.append(", maxQualifierLength=");
        builder.append(this.maxQualifierLength);
        builder.append(", maxTagLength=");
        builder.append(this.maxTagsLength);
        builder.append(", minTimestamp=");
        builder.append(this.minTimestamp);
        builder.append(", timestampDeltaWidth=");
        builder.append(this.timestampDeltaWidth);
        builder.append(", minMvccVersion=");
        builder.append(this.minMvccVersion);
        builder.append(", mvccVersionDeltaWidth=");
        builder.append(this.mvccVersionDeltaWidth);
        builder.append(", allSameType=");
        builder.append(this.allSameType);
        builder.append(", allTypes=");
        builder.append(this.allTypes);
        builder.append(", numUniqueRows=");
        builder.append(this.numUniqueRows);
        builder.append(", numUniqueFamilies=");
        builder.append(this.numUniqueFamilies);
        builder.append(", numUniqueQualifiers=");
        builder.append(this.numUniqueQualifiers);
        builder.append(", numUniqueTags=");
        builder.append(this.numUniqueTags);
        builder.append("]");
        return builder.toString();
    }

    public int getAbsoluteMetaOffset() {
        return this.arrayOffset + this.bufferOffset;
    }

    public int getAbsoluteRowOffset() {
        return this.getAbsoluteMetaOffset() + this.numMetaBytes;
    }

    public int getAbsoluteFamilyOffset() {
        return this.getAbsoluteRowOffset() + this.numRowBytes;
    }

    public int getAbsoluteQualifierOffset() {
        return this.getAbsoluteFamilyOffset() + this.numFamilyBytes;
    }

    public int getAbsoluteTagsOffset() {
        return this.getAbsoluteQualifierOffset() + this.numQualifierBytes;
    }

    public int getAbsoluteTimestampOffset() {
        return this.getAbsoluteTagsOffset() + this.numTagsBytes;
    }

    public int getAbsoluteMvccVersionOffset() {
        return this.getAbsoluteTimestampOffset() + this.numTimestampBytes;
    }

    public int getAbsoluteValueOffset() {
        return this.getAbsoluteMvccVersionOffset() + this.numMvccVersionBytes;
    }

    public int getTimestampDeltaWidth() {
        return this.timestampDeltaWidth;
    }

    public void setTimestampDeltaWidth(int timestampDeltaWidth) {
        this.timestampDeltaWidth = timestampDeltaWidth;
    }

    public int getValueOffsetWidth() {
        return this.valueOffsetWidth;
    }

    public int getTagsOffsetWidth() {
        return this.tagsOffsetWidth;
    }

    public void setValueOffsetWidth(int dataOffsetWidth) {
        this.valueOffsetWidth = dataOffsetWidth;
    }

    public void setTagsOffsetWidth(int dataOffsetWidth) {
        this.tagsOffsetWidth = dataOffsetWidth;
    }

    public int getValueLengthWidth() {
        return this.valueLengthWidth;
    }

    public void setValueLengthWidth(int dataLengthWidth) {
        this.valueLengthWidth = dataLengthWidth;
    }

    public int getMaxRowLength() {
        return this.maxRowLength;
    }

    public void setMaxRowLength(int maxRowLength) {
        this.maxRowLength = maxRowLength;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public void setMinTimestamp(long minTimestamp) {
        this.minTimestamp = minTimestamp;
    }

    public byte getAllTypes() {
        return this.allTypes;
    }

    public void setAllTypes(byte allTypes) {
        this.allTypes = allTypes;
    }

    public boolean isAllSameType() {
        return this.allSameType;
    }

    public void setAllSameType(boolean allSameType) {
        this.allSameType = allSameType;
    }

    public int getNextNodeOffsetWidth() {
        return this.nextNodeOffsetWidth;
    }

    public void setNextNodeOffsetWidth(int nextNodeOffsetWidth) {
        this.nextNodeOffsetWidth = nextNodeOffsetWidth;
    }

    public int getNumRowBytes() {
        return this.numRowBytes;
    }

    public void setNumRowBytes(int numRowBytes) {
        this.numRowBytes = numRowBytes;
    }

    public int getNumTimestampBytes() {
        return this.numTimestampBytes;
    }

    public void setNumTimestampBytes(int numTimestampBytes) {
        this.numTimestampBytes = numTimestampBytes;
    }

    public int getNumValueBytes() {
        return this.numValueBytes;
    }

    public int getNumTagsBytes() {
        return this.numTagsBytes;
    }

    public void setNumTagsBytes(int numTagBytes) {
        this.numTagsBytes = numTagBytes;
    }

    public void setNumValueBytes(int numValueBytes) {
        this.numValueBytes = numValueBytes;
    }

    public int getNumMetaBytes() {
        return this.numMetaBytes;
    }

    public void setNumMetaBytes(int numMetaBytes) {
        this.numMetaBytes = numMetaBytes;
    }

    public int getArrayOffset() {
        return this.arrayOffset;
    }

    public void setArrayOffset(int arrayOffset) {
        this.arrayOffset = arrayOffset;
    }

    public int getBufferOffset() {
        return this.bufferOffset;
    }

    public void setBufferOffset(int bufferOffset) {
        this.bufferOffset = bufferOffset;
    }

    public int getNumKeyValueBytes() {
        return this.numKeyValueBytes;
    }

    public void setNumKeyValueBytes(int numKeyValueBytes) {
        this.numKeyValueBytes = numKeyValueBytes;
    }

    public int getRowTreeDepth() {
        return this.rowTreeDepth;
    }

    public void setRowTreeDepth(int rowTreeDepth) {
        this.rowTreeDepth = rowTreeDepth;
    }

    public int getNumMvccVersionBytes() {
        return this.numMvccVersionBytes;
    }

    public void setNumMvccVersionBytes(int numMvccVersionBytes) {
        this.numMvccVersionBytes = numMvccVersionBytes;
    }

    public int getMvccVersionDeltaWidth() {
        return this.mvccVersionDeltaWidth;
    }

    public void setMvccVersionDeltaWidth(int mvccVersionDeltaWidth) {
        this.mvccVersionDeltaWidth = mvccVersionDeltaWidth;
    }

    public long getMinMvccVersion() {
        return this.minMvccVersion;
    }

    public void setMinMvccVersion(long minMvccVersion) {
        this.minMvccVersion = minMvccVersion;
    }

    public int getNumFamilyBytes() {
        return this.numFamilyBytes;
    }

    public void setNumFamilyBytes(int numFamilyBytes) {
        this.numFamilyBytes = numFamilyBytes;
    }

    public int getFamilyOffsetWidth() {
        return this.familyOffsetWidth;
    }

    public void setFamilyOffsetWidth(int familyOffsetWidth) {
        this.familyOffsetWidth = familyOffsetWidth;
    }

    public int getNumUniqueRows() {
        return this.numUniqueRows;
    }

    public void setNumUniqueRows(int numUniqueRows) {
        this.numUniqueRows = numUniqueRows;
    }

    public int getNumUniqueFamilies() {
        return this.numUniqueFamilies;
    }

    public void setNumUniqueFamilies(int numUniqueFamilies) {
        this.numUniqueFamilies = numUniqueFamilies;
    }

    public int getNumUniqueQualifiers() {
        return this.numUniqueQualifiers;
    }

    public void setNumUniqueQualifiers(int numUniqueQualifiers) {
        this.numUniqueQualifiers = numUniqueQualifiers;
    }

    public void setNumUniqueTags(int numUniqueTags) {
        this.numUniqueTags = numUniqueTags;
    }

    public int getNumUniqueTags() {
        return this.numUniqueTags;
    }

    public int getNumQualifierBytes() {
        return this.numQualifierBytes;
    }

    public void setNumQualifierBytes(int numQualifierBytes) {
        this.numQualifierBytes = numQualifierBytes;
    }

    public int getQualifierOffsetWidth() {
        return this.qualifierOffsetWidth;
    }

    public void setQualifierOffsetWidth(int qualifierOffsetWidth) {
        this.qualifierOffsetWidth = qualifierOffsetWidth;
    }

    public int getMaxQualifierLength() {
        return this.maxQualifierLength;
    }

    public void setMaxQualifierLength(int maxQualifierLength) {
        this.maxQualifierLength = maxQualifierLength;
    }

    public int getMaxTagsLength() {
        return this.maxTagsLength;
    }

    public void setMaxTagsLength(int maxTagLength) {
        this.maxTagsLength = maxTagLength;
    }

    public int getTimestampIndexWidth() {
        return this.timestampIndexWidth;
    }

    public void setTimestampIndexWidth(int timestampIndexWidth) {
        this.timestampIndexWidth = timestampIndexWidth;
    }

    public int getMvccVersionIndexWidth() {
        return this.mvccVersionIndexWidth;
    }

    public void setMvccVersionIndexWidth(int mvccVersionIndexWidth) {
        this.mvccVersionIndexWidth = mvccVersionIndexWidth;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isIncludesMvccVersion() {
        return this.includesMvccVersion;
    }

    public void setIncludesMvccVersion(boolean includesMvccVersion) {
        this.includesMvccVersion = includesMvccVersion;
    }
}

