/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.test.IntegrationTestLoadAndVerify;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestWithCellVisibilityLoadAndVerify
extends IntegrationTestLoadAndVerify {
    private static final String ERROR_STR = "Two user names are to be specified seperated by a ',' like 'usera,userb'";
    private static final char NOT = '!';
    private static final char OR = '|';
    private static final char AND = '&';
    private static final String TEST_NAME = "IntegrationTestCellVisibilityLoadAndVerify";
    private static final String CONFIDENTIAL = "confidential";
    private static final String TOPSECRET = "topsecret";
    private static final String SECRET = "secret";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String[] LABELS = new String[]{"confidential", "topsecret", "secret", "private", "public"};
    private static final String[] VISIBILITY_EXPS = new String[]{"confidential&topsecret&private", "confidential|topsecret", "public", "(secret|private)&!confidential"};
    private static final int VISIBILITY_EXPS_COUNT = VISIBILITY_EXPS.length;
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"q1");
    private static final String NUM_TO_WRITE_KEY = "loadmapper.num_to_write";
    private static final long NUM_TO_WRITE_DEFAULT = 100000L;
    private static final int SCANNER_CACHING = 500;
    private static String USER_OPT = "users";
    private static String userNames = "user1,user2";
    private long numRowsLoadedWithExp1;
    private long numRowsLoadedWithExp2;
    private long numRowsLoadWithExp3;
    private long numRowsLoadWithExp4;
    private long numRowsReadWithExp1;
    private long numRowsReadWithExp2;
    private long numRowsReadWithExp3;
    private long numRowsReadWithExp4;
    private static User USER1;
    private static User USER2;

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        Configuration conf = this.util.getConfiguration();
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
        conf.set("hbase.superuser", User.getCurrent().getName());
        conf.setBoolean("dfs.permissions", false);
        super.setUpCluster();
        String[] users = userNames.split(",");
        if (users.length != 2) {
            System.err.println(ERROR_STR);
            throw new IOException(ERROR_STR);
        }
        System.out.println(userNames + " " + users[0] + " " + users[1]);
        USER1 = User.createUserForTesting((Configuration)conf, (String)users[0], (String[])new String[0]);
        USER2 = User.createUserForTesting((Configuration)conf, (String)users[1], (String[])new String[0]);
        this.addLabelsAndAuths();
    }

    @Override
    protected void addOptions() {
        super.addOptions();
        this.addOptWithArg("u", USER_OPT, "User names to be passed");
    }

    private void addLabelsAndAuths() throws Exception {
        try {
            VisibilityClient.addLabels((Connection)this.util.getConnection(), (String[])LABELS);
            VisibilityClient.setAuths((Connection)this.util.getConnection(), (String[])new String[]{CONFIDENTIAL, TOPSECRET, SECRET, PRIVATE}, (String)USER1.getName());
            VisibilityClient.setAuths((Connection)this.util.getConnection(), (String[])new String[]{PUBLIC}, (String)USER2.getName());
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Override
    protected Job doLoad(Configuration conf, HTableDescriptor htd) throws Exception {
        Job job = super.doLoad(conf, htd);
        this.numRowsLoadedWithExp1 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_1).getValue();
        this.numRowsLoadedWithExp2 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_2).getValue();
        this.numRowsLoadWithExp3 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_3).getValue();
        this.numRowsLoadWithExp4 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_4).getValue();
        System.out.println("Rows loaded with cell visibility " + VISIBILITY_EXPS[0] + " : " + this.numRowsLoadedWithExp1);
        System.out.println("Rows loaded with cell visibility " + VISIBILITY_EXPS[1] + " : " + this.numRowsLoadedWithExp2);
        System.out.println("Rows loaded with cell visibility " + VISIBILITY_EXPS[2] + " : " + this.numRowsLoadWithExp3);
        System.out.println("Rows loaded with cell visibility " + VISIBILITY_EXPS[3] + " : " + this.numRowsLoadWithExp4);
        return job;
    }

    @Override
    protected void setMapperClass(Job job) {
        job.setMapperClass(LoadWithCellVisibilityMapper.class);
    }

    @Override
    protected void doVerify(final Configuration conf, final HTableDescriptor htd) throws Exception {
        System.out.println(String.format("Verifying for auths %s, %s, %s, %s", CONFIDENTIAL, TOPSECRET, SECRET, PRIVATE));
        PrivilegedExceptionAction<Job> scanAction = new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws Exception {
                return IntegrationTestWithCellVisibilityLoadAndVerify.this.doVerify(conf, htd, IntegrationTestWithCellVisibilityLoadAndVerify.CONFIDENTIAL, IntegrationTestWithCellVisibilityLoadAndVerify.TOPSECRET, IntegrationTestWithCellVisibilityLoadAndVerify.SECRET, IntegrationTestWithCellVisibilityLoadAndVerify.PRIVATE);
            }
        };
        Job job = (Job)USER1.runAs((PrivilegedExceptionAction)scanAction);
        this.numRowsReadWithExp1 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_1).getValue();
        this.numRowsReadWithExp2 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_2).getValue();
        this.numRowsReadWithExp3 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_3).getValue();
        this.numRowsReadWithExp4 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_4).getValue();
        Assert.assertEquals((long)this.numRowsLoadedWithExp1, (long)this.numRowsReadWithExp1);
        Assert.assertEquals((long)this.numRowsLoadedWithExp2, (long)this.numRowsReadWithExp2);
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp3);
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp4);
        System.out.println(String.format("Verifying for auths %s, %s", PRIVATE, PUBLIC));
        scanAction = new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws Exception {
                return IntegrationTestWithCellVisibilityLoadAndVerify.this.doVerify(conf, htd, IntegrationTestWithCellVisibilityLoadAndVerify.PRIVATE, IntegrationTestWithCellVisibilityLoadAndVerify.PUBLIC);
            }
        };
        job = (Job)USER1.runAs((PrivilegedExceptionAction)scanAction);
        this.numRowsReadWithExp1 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_1).getValue();
        this.numRowsReadWithExp2 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_2).getValue();
        this.numRowsReadWithExp3 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_3).getValue();
        this.numRowsReadWithExp4 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_4).getValue();
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp1);
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp2);
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp3);
        Assert.assertEquals((long)this.numRowsLoadWithExp4, (long)this.numRowsReadWithExp4);
        System.out.println(String.format("Verifying for auths %s, %s", PRIVATE, PUBLIC));
        scanAction = new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws Exception {
                return IntegrationTestWithCellVisibilityLoadAndVerify.this.doVerify(conf, htd, IntegrationTestWithCellVisibilityLoadAndVerify.PRIVATE, IntegrationTestWithCellVisibilityLoadAndVerify.PUBLIC);
            }
        };
        job = (Job)USER2.runAs((PrivilegedExceptionAction)scanAction);
        this.numRowsReadWithExp1 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_1).getValue();
        this.numRowsReadWithExp2 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_2).getValue();
        this.numRowsReadWithExp3 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_3).getValue();
        this.numRowsReadWithExp4 = job.getCounters().findCounter((Enum)Counters.ROWS_VIS_EXP_4).getValue();
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp1);
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp2);
        Assert.assertEquals((long)this.numRowsLoadWithExp3, (long)this.numRowsReadWithExp3);
        Assert.assertEquals((long)0L, (long)this.numRowsReadWithExp4);
    }

    private Job doVerify(Configuration conf, HTableDescriptor htd, String ... auths) throws IOException, InterruptedException, ClassNotFoundException {
        Path outputDir = this.getTestDir(TEST_NAME, "verify-output");
        Job job = new Job(conf);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setJobName("IntegrationTestCellVisibilityLoadAndVerify Verification for " + htd.getTableName());
        IntegrationTestWithCellVisibilityLoadAndVerify.setJobScannerConf(job);
        Scan scan = new Scan();
        scan.setAuthorizations(new Authorizations(auths));
        TableMapReduceUtil.initTableMapperJob((String)htd.getTableName().getNameAsString(), (Scan)scan, VerifyMapper.class, NullWritable.class, NullWritable.class, (Job)job);
        TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
        int scannerCaching = conf.getInt("verify.scannercaching", 500);
        TableMapReduceUtil.setScannerCaching((Job)job, (int)scannerCaching);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        return job;
    }

    private static void setJobScannerConf(Job job) {
        job.getConfiguration().setBoolean("hbase.client.log.scanner.activity", true);
        long lpr = job.getConfiguration().getLong(NUM_TO_WRITE_KEY, 100000L) / 100L;
        job.getConfiguration().setInt("hbase.mapreduce.log.scanner.rowcount", (int)lpr);
    }

    @Override
    public void printUsage() {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " -u usera,userb [-Doptions]");
        System.err.println("  Loads a table with cell visibilities and verifies with Authorizations");
        System.err.println("Options");
        System.err.println("  -Dloadmapper.table=<name>        Table to write/verify (default autogen)");
        System.err.println("  -Dloadmapper.num_to_write=<n>    Number of rows per mapper (default 100,000 per mapper)");
        System.err.println("  -Dloadmapper.numPresplits=<n>    Number of presplit regions to start with (default 40)");
        System.err.println("  -Dloadmapper.map.tasks=<n>       Number of map tasks for load (default 200)");
        System.err.println("  -Dverify.scannercaching=<n>      Number hbase scanner caching rows to read (default 50)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runTestFromCommandLine() throws Exception {
        IntegrationTestingUtility.setUseDistributedCluster(this.getConf());
        int numPresplits = this.getConf().getInt("loadmapper.numPresplits", 5);
        HTableDescriptor htd = new HTableDescriptor(this.getTablename());
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        try (HBaseAdmin admin = new HBaseAdmin(this.getConf());){
            admin.createTable(htd, Bytes.toBytes((long)0L), Bytes.toBytes((long)-1L), numPresplits);
        }
        this.doLoad(this.getConf(), htd);
        this.doVerify(this.getConf(), htd);
        this.getTestingUtil(this.getConf()).deleteTable(htd.getName());
        return 0;
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        List args = cmd.getArgList();
        if (args.size() > 0) {
            this.printUsage();
            throw new RuntimeException("No args expected.");
        }
        args.add("loadAndVerify");
        if (cmd.hasOption(USER_OPT)) {
            userNames = cmd.getOptionValue(USER_OPT);
        }
        super.processOptions(cmd);
    }

    public static void main(String[] argv) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestWithCellVisibilityLoadAndVerify(), (String[])argv);
        System.exit(ret);
    }

    public static class VerifyMapper
    extends TableMapper<BytesWritable, BytesWritable> {
        private Counter rowsExp1;
        private Counter rowsExp2;
        private Counter rowsExp3;
        private Counter rowsExp4;

        public void setup(Mapper.Context context) throws IOException {
            this.rowsExp1 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_1);
            this.rowsExp2 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_2);
            this.rowsExp3 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_3);
            this.rowsExp4 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_4);
        }

        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            byte[] row = value.getRow();
            Counter c = this.getCounter(row);
            c.increment(1L);
        }

        private Counter getCounter(byte[] row) {
            Counter c = null;
            if (Bytes.indexOf((byte[])row, (byte[])Bytes.toBytes((String)VISIBILITY_EXPS[0])) != -1) {
                c = this.rowsExp1;
            } else if (Bytes.indexOf((byte[])row, (byte[])Bytes.toBytes((String)VISIBILITY_EXPS[1])) != -1) {
                c = this.rowsExp2;
            } else if (Bytes.indexOf((byte[])row, (byte[])Bytes.toBytes((String)VISIBILITY_EXPS[2])) != -1) {
                c = this.rowsExp3;
            } else if (Bytes.indexOf((byte[])row, (byte[])Bytes.toBytes((String)VISIBILITY_EXPS[3])) != -1) {
                c = this.rowsExp4;
            }
            return c;
        }
    }

    public static class LoadWithCellVisibilityMapper
    extends IntegrationTestLoadAndVerify.LoadMapper {
        private Counter rowsExp1;
        private Counter rowsExp2;
        private Counter rowsExp3;
        private Counter rowsexp4;

        @Override
        public void setup(Mapper.Context context) throws IOException {
            super.setup(context);
            this.rowsExp1 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_1);
            this.rowsExp2 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_2);
            this.rowsExp3 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_3);
            this.rowsexp4 = context.getCounter((Enum)Counters.ROWS_VIS_EXP_4);
        }

        @Override
        protected void map(NullWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            String suffix = "/" + this.shortTaskId;
            int BLOCK_SIZE = (int)(this.recordsToWrite / 100L);
            long i = 0L;
            while (i < this.recordsToWrite) {
                for (long idx = 0L; idx < (long)BLOCK_SIZE && i < this.recordsToWrite; ++idx, ++i) {
                    int expIdx = this.rand.nextInt(BLOCK_SIZE) % VISIBILITY_EXPS_COUNT;
                    String exp = VISIBILITY_EXPS[expIdx];
                    byte[] row = Bytes.add((byte[])Bytes.toBytes((long)i), (byte[])Bytes.toBytes((String)suffix), (byte[])Bytes.toBytes((String)exp));
                    Put p = new Put(row);
                    p.add(TEST_FAMILY, TEST_QUALIFIER, HConstants.EMPTY_BYTE_ARRAY);
                    p.setCellVisibility(new CellVisibility(exp));
                    this.getCounter(expIdx).increment(1L);
                    this.mutator.mutate((Mutation)p);
                    if (i % 100L != 0L) continue;
                    context.setStatus("Written " + i + "/" + this.recordsToWrite + " records");
                    context.progress();
                }
                this.mutator.flush();
            }
        }

        private Counter getCounter(int idx) {
            switch (idx) {
                case 0: {
                    return this.rowsExp1;
                }
                case 1: {
                    return this.rowsExp2;
                }
                case 2: {
                    return this.rowsExp3;
                }
                case 3: {
                    return this.rowsexp4;
                }
            }
            return null;
        }
    }

    private static enum Counters {
        ROWS_VIS_EXP_1,
        ROWS_VIS_EXP_2,
        ROWS_VIS_EXP_3,
        ROWS_VIS_EXP_4;

    }
}

