/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactTableAction
extends Action {
    private final TableName tableName;
    private final int majorRatio;
    private final long sleepTime;
    private static final Logger LOG = LoggerFactory.getLogger(CompactTableAction.class);

    public CompactTableAction(TableName tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactTableAction(int sleepTime, TableName tableName, float majorRatio) {
        this.tableName = tableName;
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        boolean major = RandomUtils.nextInt((int)100) < this.majorRatio;
        LOG.info("Performing action: Compact table " + this.tableName + ", major=" + major);
        try {
            if (major) {
                admin.majorCompact(this.tableName);
            } else {
                admin.compact(this.tableName);
            }
        }
        catch (Exception ex) {
            LOG.warn("Compaction failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

