/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.TestUtils;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenModel;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestTopScreenModel {
    @Mock
    private Admin admin;
    private TopScreenModel topScreenModel;
    private List<Field> fields;

    @Before
    public void setup() throws IOException {
        Mockito.when((Object)this.admin.getClusterStatus()).thenReturn((Object)TestUtils.createDummyClusterStatus());
        this.topScreenModel = new TopScreenModel(this.admin, Mode.REGION);
        this.fields = new ArrayList<Field>();
        for (FieldInfo fieldInfo : Mode.REGION.getFieldInfos()) {
            this.fields.add(fieldInfo.getField());
        }
    }

    @Test
    public void testSummary() {
        this.topScreenModel.refreshMetricsData();
        Summary summary = this.topScreenModel.getSummary();
        TestUtils.assertSummary(summary);
    }

    @Test
    public void testRecords() {
        this.topScreenModel.refreshMetricsData();
        TestUtils.assertRecordsInRegionMode(this.topScreenModel.getRecords());
        this.topScreenModel.switchMode(Mode.NAMESPACE, null, false);
        this.topScreenModel.refreshMetricsData();
        TestUtils.assertRecordsInNamespaceMode(this.topScreenModel.getRecords());
        this.topScreenModel.switchMode(Mode.TABLE, null, false);
        this.topScreenModel.refreshMetricsData();
        TestUtils.assertRecordsInTableMode(this.topScreenModel.getRecords());
        this.topScreenModel.switchMode(Mode.REGION_SERVER, null, false);
        this.topScreenModel.refreshMetricsData();
        TestUtils.assertRecordsInRegionServerMode(this.topScreenModel.getRecords());
    }

    @Test
    public void testSort() {
        FieldValue current;
        this.topScreenModel.setSortFieldAndFields(Field.LOCALITY, this.fields);
        FieldValue previous = null;
        this.topScreenModel.refreshMetricsData();
        for (Record record : this.topScreenModel.getRecords()) {
            current = record.get((Object)Field.LOCALITY);
            if (previous != null) {
                Assert.assertTrue((current.compareTo(previous) < 0 ? 1 : 0) != 0);
            }
            previous = current;
        }
        this.topScreenModel.switchSortOrder();
        this.topScreenModel.refreshMetricsData();
        previous = null;
        for (Record record : this.topScreenModel.getRecords()) {
            current = record.get((Object)Field.LOCALITY);
            if (previous != null) {
                Assert.assertTrue((current.compareTo(previous) > 0 ? 1 : 0) != 0);
            }
            previous = current;
        }
    }

    @Test
    public void testFilters() {
        FieldValue value;
        this.topScreenModel.addFilter("TABLE==table1", false);
        this.topScreenModel.refreshMetricsData();
        for (Record record : this.topScreenModel.getRecords()) {
            value = record.get((Object)Field.TABLE);
            Assert.assertThat((Object)value.asString(), (Matcher)CoreMatchers.is((Object)"table1"));
        }
        this.topScreenModel.clearFilters();
        this.topScreenModel.addFilter("TABLE==TABLE1", false);
        this.topScreenModel.refreshMetricsData();
        Assert.assertThat((Object)this.topScreenModel.getRecords().size(), (Matcher)CoreMatchers.is((Object)0));
        this.topScreenModel.clearFilters();
        this.topScreenModel.addFilter("TABLE==TABLE1", true);
        this.topScreenModel.refreshMetricsData();
        for (Record record : this.topScreenModel.getRecords()) {
            value = record.get((Object)Field.TABLE);
            Assert.assertThat((Object)value.asString(), (Matcher)CoreMatchers.is((Object)"table1"));
        }
    }

    @Test
    public void testFilterHistories() {
        this.topScreenModel.addFilter("TABLE==table1", false);
        this.topScreenModel.addFilter("TABLE==table2", false);
        this.topScreenModel.addFilter("TABLE==table3", false);
        Assert.assertThat((Object)((String)this.topScreenModel.getFilterHistories().get(0)), (Matcher)CoreMatchers.is((Object)"TABLE==table1"));
        Assert.assertThat((Object)((String)this.topScreenModel.getFilterHistories().get(1)), (Matcher)CoreMatchers.is((Object)"TABLE==table2"));
        Assert.assertThat((Object)((String)this.topScreenModel.getFilterHistories().get(2)), (Matcher)CoreMatchers.is((Object)"TABLE==table3"));
    }

    @Test
    public void testSwitchMode() {
        this.topScreenModel.switchMode(Mode.TABLE, null, false);
        Assert.assertThat((Object)this.topScreenModel.getCurrentMode(), (Matcher)CoreMatchers.is((Object)Mode.TABLE));
        List<RecordFilter> initialFilters = Arrays.asList(RecordFilter.parse((String)"TABLE==table1", this.fields, (boolean)true), RecordFilter.parse((String)"TABLE==table2", this.fields, (boolean)true));
        this.topScreenModel.switchMode(Mode.TABLE, initialFilters, false);
        Assert.assertThat((Object)this.topScreenModel.getFilters().size(), (Matcher)CoreMatchers.is((Object)initialFilters.size()));
        for (int i = 0; i < this.topScreenModel.getFilters().size(); ++i) {
            Assert.assertThat((Object)((RecordFilter)this.topScreenModel.getFilters().get(i)).toString(), (Matcher)CoreMatchers.is((Object)initialFilters.get(i).toString()));
        }
        this.topScreenModel.setSortFieldAndFields(Field.NAMESPACE, this.fields);
        this.topScreenModel.switchMode(Mode.NAMESPACE, null, true);
        Assert.assertThat((Object)this.topScreenModel.getCurrentSortField(), (Matcher)CoreMatchers.is((Object)Field.NAMESPACE));
    }

    @Test
    public void testDrillDown() {
        this.topScreenModel.switchMode(Mode.TABLE, null, false);
        this.topScreenModel.setSortFieldAndFields(Field.NAMESPACE, this.fields);
        this.topScreenModel.refreshMetricsData();
        boolean success = this.topScreenModel.drillDown((Record)this.topScreenModel.getRecords().get(0));
        Assert.assertThat((Object)success, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((RecordFilter)this.topScreenModel.getFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"NAMESPACE==namespace"));
        Assert.assertThat((Object)((RecordFilter)this.topScreenModel.getFilters().get(1)).toString(), (Matcher)CoreMatchers.is((Object)"TABLE==table3"));
        Assert.assertThat((Object)this.topScreenModel.getCurrentSortField(), (Matcher)CoreMatchers.is((Object)Field.NAMESPACE));
    }
}

