/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.mode;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestModeScreenPresenter {
    @Mock
    private ModeScreenView modeScreenView;
    @Mock
    private TopScreenView topScreenView;
    @Mock
    private ModeScreenPresenter.ResultListener resultListener;

    private ModeScreenPresenter createModeScreenPresenter(Mode currentMode) {
        return new ModeScreenPresenter(this.modeScreenView, currentMode, this.resultListener, (ScreenView)this.topScreenView);
    }

    @Test
    public void testInit() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.init();
        int modeHeaderMaxLength = Mode.REGION_SERVER.getHeader().length();
        int modeDescriptionMaxLength = Mode.REGION_SERVER.getDescription().length();
        ((ModeScreenView)Mockito.verify((Object)this.modeScreenView)).showModeScreen((Mode)Mockito.eq((Object)Mode.REGION), (List)Mockito.eq(Arrays.asList(Mode.values())), Mockito.eq((int)Mode.REGION.ordinal()), Mockito.eq((int)modeHeaderMaxLength), Mockito.eq((int)modeDescriptionMaxLength));
    }

    @Test
    public void testSelectNamespaceMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowUp();
        modeScreenPresenter.arrowUp();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Mode)Mockito.eq((Object)Mode.NAMESPACE));
    }

    @Test
    public void testSelectTableMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowUp();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Mode)Mockito.eq((Object)Mode.TABLE));
    }

    @Test
    public void testSelectRegionMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.NAMESPACE);
        modeScreenPresenter.arrowDown();
        modeScreenPresenter.arrowDown();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Mode)Mockito.eq((Object)Mode.REGION));
    }

    @Test
    public void testSelectRegionServerMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowDown();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Mode)Mockito.eq((Object)Mode.REGION_SERVER));
    }

    @Test
    public void testCancelSelectingMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowDown();
        modeScreenPresenter.arrowDown();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(false), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener, (VerificationMode)Mockito.never())).accept((Mode)Mockito.any(Mode.class));
    }

    @Test
    public void testPageUp() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.pageUp();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Mode)Mockito.eq((Object)Mode.values()[0]));
    }

    @Test
    public void testPageDown() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.pageDown();
        Assert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        Mode[] modes = Mode.values();
        ((ModeScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Mode)Mockito.eq((Object)modes[modes.length - 1]));
    }
}

