/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalSize;

@InterfaceAudience.Private
public abstract class AbstractScreenView
implements ScreenView {
    private final Screen screen;
    private final Terminal terminal;

    public AbstractScreenView(Screen screen, Terminal terminal) {
        this.screen = Objects.requireNonNull(screen);
        this.terminal = Objects.requireNonNull(terminal);
    }

    @Override
    public void init() {
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        return this;
    }

    @Override
    public ScreenView handleTimer() {
        return this;
    }

    protected Screen getScreen() {
        return this.screen;
    }

    protected Terminal getTerminal() {
        return this.terminal;
    }

    protected void setTimer(long delay) {
        this.screen.setTimer(delay);
    }

    protected void cancelTimer() {
        this.screen.cancelTimer();
    }

    protected TerminalPrinter getTerminalPrinter(int startRow) {
        return this.terminal.getTerminalPrinter(startRow);
    }

    protected TerminalSize getTerminalSize() {
        return this.terminal.getSize();
    }

    @Nullable
    protected TerminalSize doResizeIfNecessary() {
        return this.terminal.doResizeIfNecessary();
    }

    public void clearTerminal() {
        this.terminal.clear();
    }

    public void refreshTerminal() {
        this.terminal.refresh();
    }

    public void hideCursor() {
        this.terminal.hideCursor();
    }

    public void setCursorPosition(int column, int row) {
        this.terminal.setCursorPosition(column, row);
    }
}

