/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.field;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestFieldScreenPresenter {
    @Mock
    private FieldScreenView fieldScreenView;
    private int sortFieldPosition = -1;
    private List<Field> fields;
    private EnumMap<Field, Boolean> fieldDisplayMap;
    @Mock
    private FieldScreenPresenter.ResultListener resultListener;
    @Mock
    private TopScreenView topScreenView;
    private FieldScreenPresenter fieldScreenPresenter;

    @Before
    public void setup() {
        Field sortField = Mode.REGION.getDefaultSortField();
        this.fields = new ArrayList<Field>();
        for (FieldInfo fieldInfo : Mode.REGION.getFieldInfos()) {
            this.fields.add(fieldInfo.getField());
        }
        this.fieldDisplayMap = new EnumMap(Field.class);
        for (FieldInfo fieldInfo : Mode.REGION.getFieldInfos()) {
            this.fieldDisplayMap.put(fieldInfo.getField(), fieldInfo.isDisplayByDefault());
        }
        this.fieldScreenPresenter = new FieldScreenPresenter(this.fieldScreenView, sortField, this.fields, this.fieldDisplayMap, this.resultListener, (ScreenView)this.topScreenView);
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (field != sortField) continue;
            this.sortFieldPosition = i;
            break;
        }
    }

    @Test
    public void testInit() {
        this.fieldScreenPresenter.init();
        int modeHeaderMaxLength = "#COMPingCell".length();
        int modeDescriptionMaxLength = "Write Request Count per second".length();
        ((FieldScreenView)Mockito.verify((Object)this.fieldScreenView)).showFieldScreen((String)Mockito.eq((Object)"#REQ/S"), (List)Mockito.eq(this.fields), (EnumMap)Mockito.eq(this.fieldDisplayMap), Mockito.eq((int)this.sortFieldPosition), Mockito.eq((int)modeHeaderMaxLength), Mockito.eq((int)modeDescriptionMaxLength), Mockito.eq((boolean)false));
    }

    @Test
    public void testChangeSortField() {
        this.fieldScreenPresenter.arrowUp();
        this.fieldScreenPresenter.setSortField();
        this.fieldScreenPresenter.arrowDown();
        this.fieldScreenPresenter.arrowDown();
        this.fieldScreenPresenter.setSortField();
        this.fieldScreenPresenter.pageUp();
        this.fieldScreenPresenter.setSortField();
        this.fieldScreenPresenter.pageDown();
        this.fieldScreenPresenter.setSortField();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fieldScreenView});
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)Mockito.eq((Object)"LRS"));
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)Mockito.eq((Object)"#READ/S"));
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)Mockito.eq((Object)this.fields.get(0).getHeader()));
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)Mockito.eq((Object)this.fields.get(this.fields.size() - 1).getHeader()));
    }

    @Test
    public void testSwitchFieldDisplay() {
        this.fieldScreenPresenter.switchFieldDisplay();
        this.fieldScreenPresenter.switchFieldDisplay();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fieldScreenView});
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showField(Mockito.anyInt(), (Field)Mockito.any(Field.class), Mockito.eq((boolean)false), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyBoolean());
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showField(Mockito.anyInt(), (Field)Mockito.any(Field.class), Mockito.eq((boolean)true), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyBoolean());
    }

    @Test
    public void testChangeFieldsOrder() {
        this.fieldScreenPresenter.turnOnMoveMode();
        this.fieldScreenPresenter.arrowUp();
        this.fieldScreenPresenter.turnOffMoveMode();
        Field removed = this.fields.remove(this.sortFieldPosition);
        this.fields.add(this.sortFieldPosition - 1, removed);
        Assert.assertThat((Object)this.fieldScreenPresenter.transitionToNextScreen(), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((FieldScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Field)Mockito.any(Field.class), (List)Mockito.eq(this.fields), (EnumMap)Mockito.any(EnumMap.class));
    }
}

