/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import java.util.Objects;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.hbtop.terminal.Attributes;
import org.apache.hadoop.hbase.hbtop.terminal.Color;

@InterfaceAudience.Private
public class Cell {
    private static final char UNSET_VALUE = '\uffff';
    private static final char END_OF_LINE = '\u0000';
    private final Attributes attributes = new Attributes();
    private char ch = (char)32;

    public char getChar() {
        return this.ch;
    }

    public void setChar(char ch) {
        this.ch = ch;
    }

    public void reset() {
        this.attributes.reset();
        this.ch = (char)32;
    }

    public void unset() {
        this.attributes.reset();
        this.ch = (char)65535;
    }

    public void endOfLine() {
        this.attributes.reset();
        this.ch = '\u0000';
    }

    public boolean isEndOfLine() {
        return this.ch == '\u0000';
    }

    public void set(Cell cell) {
        this.attributes.set(cell.attributes);
        this.ch = cell.ch;
    }

    public Attributes getAttributes() {
        return new Attributes(this.attributes);
    }

    public void setAttributes(Attributes attributes) {
        this.attributes.set(attributes);
    }

    public boolean isBold() {
        return this.attributes.isBold();
    }

    public boolean isBlink() {
        return this.attributes.isBlink();
    }

    public boolean isReverse() {
        return this.attributes.isReverse();
    }

    public boolean isUnderline() {
        return this.attributes.isUnderline();
    }

    public Color getForegroundColor() {
        return this.attributes.getForegroundColor();
    }

    public Color getBackgroundColor() {
        return this.attributes.getBackgroundColor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.ch == cell.ch && this.attributes.equals(cell.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, Character.valueOf(this.ch));
    }
}

