/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.Header;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenModel;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalSize;

@InterfaceAudience.Private
public class TopScreenView
extends AbstractScreenView {
    private static final int SUMMARY_START_ROW = 0;
    private static final int SUMMARY_ROW_NUM = 7;
    private static final int MESSAGE_ROW = 7;
    private static final int RECORD_HEADER_ROW = 8;
    private static final int RECORD_START_ROW = 9;
    private final TopScreenPresenter topScreenPresenter;
    private int pageSize;

    public TopScreenView(Screen screen, Terminal terminal, long initialRefreshDelay, Admin admin, Mode initialMode) {
        super(screen, terminal);
        this.topScreenPresenter = new TopScreenPresenter(this, initialRefreshDelay, new TopScreenModel(admin, initialMode));
    }

    @Override
    public void init() {
        this.topScreenPresenter.init();
        long delay = this.topScreenPresenter.refresh(true);
        this.setTimer(delay);
    }

    @Override
    public ScreenView handleTimer() {
        long delay = this.topScreenPresenter.refresh(false);
        this.setTimer(delay);
        return this;
    }

    @Override
    @Nullable
    public ScreenView handleKeyPress(KeyPress keyPress) {
        switch (keyPress.getType()) {
            case Enter: {
                this.topScreenPresenter.refresh(true);
                return this;
            }
            case ArrowUp: {
                this.topScreenPresenter.arrowUp();
                return this;
            }
            case ArrowDown: {
                this.topScreenPresenter.arrowDown();
                return this;
            }
            case ArrowLeft: {
                this.topScreenPresenter.arrowLeft();
                return this;
            }
            case ArrowRight: {
                this.topScreenPresenter.arrowRight();
                return this;
            }
            case PageUp: {
                this.topScreenPresenter.pageUp();
                return this;
            }
            case PageDown: {
                this.topScreenPresenter.pageDown();
                return this;
            }
            case Home: {
                this.topScreenPresenter.home();
                return this;
            }
            case End: {
                this.topScreenPresenter.end();
                return this;
            }
            case Escape: {
                return null;
            }
        }
        if (keyPress.getType() != KeyPress.Type.Character) {
            return this.unknownCommandMessage();
        }
        assert (keyPress.getCharacter() != null);
        switch (keyPress.getCharacter().charValue()) {
            case 'R': {
                this.topScreenPresenter.switchSortOrder();
                break;
            }
            case 'f': {
                this.cancelTimer();
                return this.topScreenPresenter.transitionToFieldScreen(this.getScreen(), this.getTerminal());
            }
            case 'm': {
                this.cancelTimer();
                return this.topScreenPresenter.transitionToModeScreen(this.getScreen(), this.getTerminal());
            }
            case 'h': {
                this.cancelTimer();
                return this.topScreenPresenter.transitionToHelpScreen(this.getScreen(), this.getTerminal());
            }
            case 'd': {
                this.cancelTimer();
                return this.topScreenPresenter.goToInputModeForRefreshDelay(this.getScreen(), this.getTerminal(), 7);
            }
            case 'o': {
                this.cancelTimer();
                if (keyPress.isCtrl()) {
                    return this.topScreenPresenter.goToFilterDisplayMode(this.getScreen(), this.getTerminal(), 7);
                }
                return this.topScreenPresenter.goToInputModeForFilter(this.getScreen(), this.getTerminal(), 7, true);
            }
            case 'O': {
                this.cancelTimer();
                return this.topScreenPresenter.goToInputModeForFilter(this.getScreen(), this.getTerminal(), 7, false);
            }
            case '=': {
                this.topScreenPresenter.clearFilters();
                break;
            }
            case 'X': {
                this.topScreenPresenter.adjustFieldLength();
                break;
            }
            case 'i': {
                this.topScreenPresenter.drillDown();
                break;
            }
            case 'q': {
                return null;
            }
            default: {
                return this.unknownCommandMessage();
            }
        }
        return this;
    }

    @Override
    public TerminalSize getTerminalSize() {
        TerminalSize terminalSize = super.getTerminalSize();
        this.updatePageSize(terminalSize);
        return terminalSize;
    }

    @Override
    public TerminalSize doResizeIfNecessary() {
        TerminalSize terminalSize = super.doResizeIfNecessary();
        if (terminalSize == null) {
            return null;
        }
        this.updatePageSize(terminalSize);
        return terminalSize;
    }

    private void updatePageSize(TerminalSize terminalSize) {
        this.pageSize = terminalSize.getRows() - 7 - 2;
        if (this.pageSize < 0) {
            this.pageSize = 0;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void showTopScreen(Summary summary, List<Header> headers, List<Record> records, Record selectedRecord) {
        this.showSummary(summary);
        this.clearMessage();
        this.showHeaders(headers);
        this.showRecords(headers, records, selectedRecord);
    }

    private void showSummary(Summary summary) {
        TerminalPrinter printer = this.getTerminalPrinter(0);
        printer.print(String.format("HBase hbtop - %s", summary.getCurrentTime())).endOfLine();
        printer.print(String.format("Version: %s", summary.getVersion())).endOfLine();
        printer.print(String.format("Cluster ID: %s", summary.getClusterId())).endOfLine();
        printer.print("RegionServer(s): ").startBold().print(Integer.toString(summary.getServers())).stopBold().print(" total, ").startBold().print(Integer.toString(summary.getLiveServers())).stopBold().print(" live, ").startBold().print(Integer.toString(summary.getDeadServers())).stopBold().print(" dead").endOfLine();
        printer.print("RegionCount: ").startBold().print(Integer.toString(summary.getRegionCount())).stopBold().print(" total, ").startBold().print(Integer.toString(summary.getRitCount())).stopBold().print(" rit").endOfLine();
        printer.print("Average Cluster Load: ").startBold().print(String.format("%.2f", summary.getAverageLoad())).stopBold().endOfLine();
        printer.print("Aggregate Request/s: ").startBold().print(Long.toString(summary.getAggregateRequestPerSecond())).stopBold().endOfLine();
    }

    private void showRecords(List<Header> headers, List<Record> records, Record selectedRecord) {
        TerminalPrinter printer = this.getTerminalPrinter(9);
        ArrayList<String> buf = new ArrayList<String>(headers.size());
        for (int i = 0; i < this.pageSize; ++i) {
            if (i < records.size()) {
                Record record = records.get(i);
                buf.clear();
                for (Header header : headers) {
                    String value = "";
                    if (record.containsKey((Object)header.getField())) {
                        value = record.get((Object)header.getField()).asString();
                    }
                    buf.add(this.limitLineLength(String.format(header.format(), value), header.getLength()));
                }
                Object recordString = StringUtils.join(buf, (String)" ");
                if (!((String)recordString).isEmpty()) {
                    recordString = (String)recordString + " ";
                }
                if (record == selectedRecord) {
                    printer.startHighlight().print((String)recordString).stopHighlight().endOfLine();
                    continue;
                }
                printer.print((String)recordString).endOfLine();
                continue;
            }
            printer.endOfLine();
        }
    }

    private void showHeaders(List<Header> headers) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        for (Header header : headers) {
            headerStrings.add(String.format(header.format(), header.getField().getHeader()));
        }
        Object header = StringUtils.join(headerStrings, (String)" ");
        if (!((String)header).isEmpty()) {
            header = (String)header + " ";
        }
        this.getTerminalPrinter(8).startHighlight().print((String)header).stopHighlight().endOfLine();
    }

    private String limitLineLength(String line, int length) {
        if (line.length() > length) {
            return line.substring(0, length - 1) + "+";
        }
        return line;
    }

    private void clearMessage() {
        this.getTerminalPrinter(7).print("").endOfLine();
    }

    private ScreenView unknownCommandMessage() {
        this.cancelTimer();
        return this.topScreenPresenter.goToMessageMode(this.getScreen(), this.getTerminal(), 7, "Unknown command - try 'h' for help");
    }
}

