/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.mode;

import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;

@InterfaceAudience.Private
public class ModeScreenView
extends AbstractScreenView {
    private static final int SCREEN_DESCRIPTION_START_ROW = 0;
    private static final int MODE_START_ROW = 4;
    private final ModeScreenPresenter modeScreenPresenter;

    public ModeScreenView(Screen screen, Terminal terminal, Mode currentMode, ModeScreenPresenter.ResultListener resultListener, ScreenView nextScreenView) {
        super(screen, terminal);
        this.modeScreenPresenter = new ModeScreenPresenter(this, currentMode, resultListener, nextScreenView);
    }

    @Override
    public void init() {
        this.modeScreenPresenter.init();
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        switch (keyPress.getType()) {
            case Escape: {
                return this.modeScreenPresenter.transitionToNextScreen(false);
            }
            case Enter: {
                return this.modeScreenPresenter.transitionToNextScreen(true);
            }
            case ArrowUp: {
                this.modeScreenPresenter.arrowUp();
                return this;
            }
            case ArrowDown: {
                this.modeScreenPresenter.arrowDown();
                return this;
            }
            case PageUp: 
            case Home: {
                this.modeScreenPresenter.pageUp();
                return this;
            }
            case PageDown: 
            case End: {
                this.modeScreenPresenter.pageDown();
                return this;
            }
        }
        if (keyPress.getType() != KeyPress.Type.Character) {
            return this;
        }
        assert (keyPress.getCharacter() != null);
        switch (keyPress.getCharacter().charValue()) {
            case 'q': {
                return this.modeScreenPresenter.transitionToNextScreen(false);
            }
        }
        return this;
    }

    public void showModeScreen(Mode currentMode, List<Mode> modes, int currentPosition, int modeHeaderMaxLength, int modeDescriptionMaxLength) {
        this.showScreenDescription(currentMode);
        for (int i = 0; i < modes.size(); ++i) {
            this.showMode(i, modes.get(i), i == currentPosition, modeHeaderMaxLength, modeDescriptionMaxLength);
        }
    }

    private void showScreenDescription(Mode currentMode) {
        TerminalPrinter printer = this.getTerminalPrinter(0);
        printer.startBold().print("Mode Management").stopBold().endOfLine();
        printer.print("Current mode: ").startBold().print(currentMode.getHeader()).stopBold().endOfLine();
        printer.print("Select mode followed by <Enter>").endOfLine();
    }

    public void showMode(int pos, Mode mode, boolean selected, int modeHeaderMaxLength, int modeDescriptionMaxLength) {
        String modeHeader = String.format("%-" + modeHeaderMaxLength + "s", mode.getHeader());
        String modeDescription = String.format("%-" + modeDescriptionMaxLength + "s", mode.getDescription());
        int row = 4 + pos;
        TerminalPrinter printer = this.getTerminalPrinter(row);
        if (selected) {
            printer.startHighlight().print(modeHeader).stopHighlight().printFormat(" = %s", modeDescription).endOfLine();
        } else {
            printer.printFormat("%s = %s", modeHeader, modeDescription).endOfLine();
        }
    }
}

