/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import java.util.Objects;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HBTop
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(HBTop.class);

    public HBTop() {
        this(HBaseConfiguration.create());
    }

    public HBTop(Configuration conf) {
        super(Objects.requireNonNull(conf));
    }

    public int run(String[] args) throws Exception {
        long initialRefreshDelay = 3000L;
        Mode initialMode = Mode.REGION;
        try {
            Options opts = new Options();
            opts.addOption("h", "help", false, "Print usage; for help while the tool is running press 'h'");
            opts.addOption("d", "delay", true, "The refresh delay (in seconds); default is 3 seconds");
            opts.addOption("m", "mode", true, "The mode; n (Namespace)|t (Table)|r (Region)|s (RegionServer), default is r (Region)");
            CommandLine commandLine = new BasicParser().parse(opts, args);
            if (commandLine.hasOption("help")) {
                this.printUsage(opts);
                return 0;
            }
            if (commandLine.hasOption("delay")) {
                int delay = 0;
                try {
                    delay = Integer.parseInt(commandLine.getOptionValue("delay"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (delay < 1) {
                    LOG.warn((Object)"Delay set too low or invalid, using default");
                } else {
                    initialRefreshDelay = (long)delay * 1000L;
                }
            }
            if (commandLine.hasOption("mode")) {
                String mode;
                switch (mode = commandLine.getOptionValue("mode")) {
                    case "n": {
                        initialMode = Mode.NAMESPACE;
                        break;
                    }
                    case "t": {
                        initialMode = Mode.TABLE;
                        break;
                    }
                    case "r": {
                        initialMode = Mode.REGION;
                        break;
                    }
                    case "s": {
                        initialMode = Mode.REGION_SERVER;
                        break;
                    }
                    default: {
                        LOG.warn((Object)"Mode set invalid, using default");
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to parse options", (Throwable)e);
            return 1;
        }
        try (Screen screen = new Screen(this.getConf(), initialRefreshDelay, initialMode);){
            screen.run();
        }
        return 0;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("hbase hbtop [opts] [-D<property=value>]*", opts);
        System.out.println("");
        System.out.println(" Note: -D properties will be applied to the conf used.");
        System.out.println("  For example:");
        System.out.println("   -Dhbase.client.zookeeper.quorum=<zookeeper quorum>");
        System.out.println("   -Dzookeeper.znode.parent=<znode parent>");
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new HBTop(), (String[])args);
        System.exit(res);
    }
}

