/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.List;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.TestUtils;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.TestModeBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableMode
extends TestModeBase {
    @Override
    protected Mode getMode() {
        return Mode.TABLE;
    }

    @Override
    protected void assertRecords(List<Record> records) {
        TestUtils.assertRecordsInTableMode(records);
    }

    @Override
    protected void assertDrillDown(Record currentRecord, DrillDownInfo drillDownInfo) {
        String tableName;
        Assert.assertThat((Object)drillDownInfo.getNextMode(), (Matcher)CoreMatchers.is((Object)Mode.REGION));
        Assert.assertThat((Object)drillDownInfo.getInitialFilters().size(), (Matcher)CoreMatchers.is((Object)2));
        switch (tableName = String.format("%s:%s", currentRecord.get((Object)Field.NAMESPACE).asString(), currentRecord.get((Object)Field.TABLE).asString())) {
            case "default:table1": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"NAMESPACE==default"));
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(1)).toString(), (Matcher)CoreMatchers.is((Object)"TABLE==table1"));
                break;
            }
            case "default:table2": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"NAMESPACE==default"));
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(1)).toString(), (Matcher)CoreMatchers.is((Object)"TABLE==table2"));
                break;
            }
            case "namespace:table3": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"NAMESPACE==namespace"));
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(1)).toString(), (Matcher)CoreMatchers.is((Object)"TABLE==table3"));
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }
}

