/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.example.generated.ExampleProtos;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class RowCountEndpoint
extends ExampleProtos.RowCountService
implements Coprocessor,
CoprocessorService {
    private RegionCoprocessorEnvironment env;

    public Service getService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRowCount(RpcController controller, ExampleProtos.CountRequest request, RpcCallback<ExampleProtos.CountResponse> done) {
        Scan scan = new Scan();
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        ExampleProtos.CountResponse response = null;
        RegionScanner scanner = null;
        try {
            scanner = this.env.getRegion().getScanner(scan);
            ArrayList results = new ArrayList();
            boolean hasMore = false;
            byte[] lastRow = null;
            long count = 0L;
            do {
                hasMore = scanner.next(results);
                for (Cell kv : results) {
                    byte[] currentRow = CellUtil.cloneRow((Cell)kv);
                    if (lastRow != null && Bytes.equals((byte[])lastRow, (byte[])currentRow)) continue;
                    lastRow = currentRow;
                    ++count;
                }
                results.clear();
            } while (hasMore);
            response = ExampleProtos.CountResponse.newBuilder().setCount(count).build();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException iOException) {}
            }
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getKeyValueCount(RpcController controller, ExampleProtos.CountRequest request, RpcCallback<ExampleProtos.CountResponse> done) {
        ExampleProtos.CountResponse response = null;
        RegionScanner scanner = null;
        try {
            scanner = this.env.getRegion().getScanner(new Scan());
            ArrayList results = new ArrayList();
            boolean hasMore = false;
            long count = 0L;
            do {
                hasMore = scanner.next(results);
                for (Cell kv : results) {
                    ++count;
                }
                results.clear();
            } while (hasMore);
            response = ExampleProtos.CountResponse.newBuilder().setCount(count).build();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException iOException) {}
            }
        }
        done.run(response);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

