/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;

public class ExampleMasterObserverWithMetrics
extends BaseMasterObserver {
    private static final Log LOG = LogFactory.getLog(ExampleMasterObserverWithMetrics.class);
    private Timer createTableTimer;
    private long createTableStartTime = Long.MIN_VALUE;
    private Counter disableTableCounter;

    private long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    private long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        super.preCreateTable(ctx, desc, regions);
        this.createTableStartTime = System.currentTimeMillis();
    }

    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        super.postCreateTable(ctx, desc, regions);
        if (this.createTableStartTime > 0L) {
            long time = System.currentTimeMillis() - this.createTableStartTime;
            LOG.info((Object)("Create table took: " + time));
            this.createTableTimer.updateMillis(time);
        }
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        super.preDisableTable(ctx, tableName);
        this.disableTableCounter.increment();
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        super.start(env);
        if (env instanceof MasterCoprocessorEnvironment) {
            MetricRegistry registry = ((MasterCoprocessorEnvironment)env).getMetricRegistryForMaster();
            if (this.createTableTimer == null) {
                this.createTableTimer = registry.timer("CreateTable");
            }
            if (this.disableTableCounter == null) {
                this.disableTableCounter = registry.counter("DisableTable");
            }
            registry.register("totalMemory", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return ExampleMasterObserverWithMetrics.this.getTotalMemory();
                }
            });
            registry.register("maxMemory", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return ExampleMasterObserverWithMetrics.this.getMaxMemory();
                }
            });
        }
    }
}

