/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class HeapMemorySizeUtil {
    public static final String MEMSTORE_SIZE_KEY = "hbase.regionserver.global.memstore.size";
    public static final String MEMSTORE_SIZE_OLD_KEY = "hbase.regionserver.global.memstore.upperLimit";
    public static final String MEMSTORE_SIZE_LOWER_LIMIT_KEY = "hbase.regionserver.global.memstore.size.lower.limit";
    public static final String MEMSTORE_SIZE_LOWER_LIMIT_OLD_KEY = "hbase.regionserver.global.memstore.lowerLimit";
    public static final float DEFAULT_MEMSTORE_SIZE = 0.4f;
    public static final float DEFAULT_MEMSTORE_SIZE_LOWER_LIMIT = 0.95f;
    private static final Log LOG = LogFactory.getLog(HeapMemorySizeUtil.class);
    private static final int CONVERT_TO_PERCENTAGE = 100;
    private static final String JVM_HEAP_EXCEPTION = "Got an exception while attempting to read information about the JVM heap. Please submit this log information in a bug report and include your JVM settings, specifically the GC in use and any -XX options. Consider restarting the service.";

    public static MemoryUsage safeGetHeapMemoryUsage() {
        MemoryUsage usage = null;
        try {
            usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        }
        catch (RuntimeException exception) {
            LOG.warn((Object)JVM_HEAP_EXCEPTION, (Throwable)exception);
        }
        return usage;
    }

    public static void checkForClusterFreeMemoryLimit(Configuration conf) {
        float blockCacheUpperLimit;
        int bcul;
        float globalMemstoreSize;
        int gml;
        if (conf.get(MEMSTORE_SIZE_OLD_KEY) != null) {
            LOG.warn((Object)"hbase.regionserver.global.memstore.upperLimit is deprecated by hbase.regionserver.global.memstore.size");
        }
        if (100 - ((gml = (int)((globalMemstoreSize = HeapMemorySizeUtil.getGlobalMemStorePercent(conf, false)) * 100.0f)) + (bcul = (int)((blockCacheUpperLimit = HeapMemorySizeUtil.getBlockCacheHeapPercent(conf)) * 100.0f))) < 20) {
            throw new RuntimeException("Current heap configuration for MemStore and BlockCache exceeds the threshold required for successful cluster operation. The combined value cannot exceed 0.8. Please check the settings for hbase.regionserver.global.memstore.size and hfile.block.cache.size in your configuration. hbase.regionserver.global.memstore.size is " + globalMemstoreSize + " hfile.block.cache.size is " + blockCacheUpperLimit);
        }
    }

    public static float getGlobalMemStorePercent(Configuration c, boolean logInvalid) {
        float limit = c.getFloat(MEMSTORE_SIZE_KEY, c.getFloat(MEMSTORE_SIZE_OLD_KEY, 0.4f));
        if (limit > 0.8f || limit <= 0.0f) {
            if (logInvalid) {
                LOG.warn((Object)"Setting global memstore limit to default of 0.4 because supplied value outside allowed range of (0 -> 0.8]");
            }
            limit = 0.4f;
        }
        return limit;
    }

    public static float getGlobalMemStoreLowerMark(Configuration conf, float globalMemStorePercent) {
        String lowMarkPercentStr = conf.get(MEMSTORE_SIZE_LOWER_LIMIT_KEY);
        if (lowMarkPercentStr != null) {
            float lowMarkPercent = Float.parseFloat(lowMarkPercentStr);
            if (lowMarkPercent > 1.0f) {
                LOG.error((Object)("Bad configuration value for hbase.regionserver.global.memstore.size.lower.limit: " + lowMarkPercent + ". Using 1.0f instead."));
                lowMarkPercent = 1.0f;
            }
            return lowMarkPercent;
        }
        String lowerWaterMarkOldValStr = conf.get(MEMSTORE_SIZE_LOWER_LIMIT_OLD_KEY);
        if (lowerWaterMarkOldValStr != null) {
            LOG.warn((Object)"hbase.regionserver.global.memstore.lowerLimit is deprecated. Instead use hbase.regionserver.global.memstore.size.lower.limit");
            float lowerWaterMarkOldVal = Float.parseFloat(lowerWaterMarkOldValStr);
            if (lowerWaterMarkOldVal > globalMemStorePercent) {
                lowerWaterMarkOldVal = globalMemStorePercent;
                LOG.error((Object)("Value of hbase.regionserver.global.memstore.lowerLimit (" + lowerWaterMarkOldVal + ") is greater than global memstore limit (" + globalMemStorePercent + ") set by hbase.regionserver.global.memstore.size/hbase.regionserver.global.memstore.upperLimit. Setting memstore lower limit to " + globalMemStorePercent));
            }
            return lowerWaterMarkOldVal / globalMemStorePercent;
        }
        return 0.95f;
    }

    public static float getBlockCacheHeapPercent(Configuration conf) {
        float l1CachePercent = conf.getFloat("hfile.block.cache.size", 0.4f);
        float l2CachePercent = HeapMemorySizeUtil.getL2BlockCacheHeapPercent(conf);
        return l1CachePercent + l2CachePercent;
    }

    public static float getL2BlockCacheHeapPercent(Configuration conf) {
        float l2CachePercent = 0.0f;
        String bucketCacheIOEngineName = conf.get("hbase.bucketcache.ioengine", null);
        if (bucketCacheIOEngineName != null && bucketCacheIOEngineName.startsWith("heap")) {
            float bucketCachePercentage = conf.getFloat("hbase.bucketcache.size", 0.0f);
            long max = -1L;
            MemoryUsage usage = HeapMemorySizeUtil.safeGetHeapMemoryUsage();
            if (usage != null) {
                max = usage.getMax();
            }
            l2CachePercent = bucketCachePercentage < 1.0f ? bucketCachePercentage : bucketCachePercentage * 1024.0f * 1024.0f / (float)max;
        }
        return l2CachePercent;
    }

    public static long getLruCacheSize(Configuration conf) {
        float cachePercentage = conf.getFloat("hfile.block.cache.size", 0.4f);
        if (cachePercentage <= 1.0E-4f) {
            return -1L;
        }
        if ((double)cachePercentage > 1.0) {
            throw new IllegalArgumentException("hfile.block.cache.size must be between 0.0 and 1.0, and not > 1.0");
        }
        long max = -1L;
        MemoryUsage usage = HeapMemorySizeUtil.safeGetHeapMemoryUsage();
        if (usage != null) {
            max = usage.getMax();
        }
        return (long)((float)max * cachePercentage);
    }

    public static long getBucketCacheSize(Configuration conf) {
        long bucketCacheSize;
        float bucketCachePercentage = conf.getFloat("hbase.bucketcache.size", 0.0f);
        if (bucketCachePercentage < 1.0f) {
            long max = -1L;
            MemoryUsage usage = HeapMemorySizeUtil.safeGetHeapMemoryUsage();
            if (usage != null) {
                max = usage.getMax();
            }
            bucketCacheSize = (long)((float)max * bucketCachePercentage);
        } else {
            bucketCacheSize = (long)(bucketCachePercentage * 1024.0f * 1024.0f);
        }
        return bucketCacheSize;
    }
}

