/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.SecureBulkLoadClient;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={ClientTests.class, SmallTests.class})
public class TestSecureBulkLoadClient {
    private static final DoNotRetryIOException DNRIOE = new DoNotRetryIOException("Go away and don't come back");
    private CoprocessorRpcChannel rpcChannel;
    private Table table;
    private SecureBulkLoadClient client;

    @Before
    public void setupMembers() {
        this.rpcChannel = (CoprocessorRpcChannel)Mockito.mock(CoprocessorRpcChannel.class);
        this.table = (Table)Mockito.mock(Table.class);
        this.client = new SecureBulkLoadClient(this.table);
        Mockito.when((Object)this.table.coprocessorService(HConstants.EMPTY_START_ROW)).thenReturn((Object)this.rpcChannel);
    }

    private void setupMockForMethod(final String expectedMethodName, final Message response, final IOException failureCause) {
        ((CoprocessorRpcChannel)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Descriptors.MethodDescriptor method = (Descriptors.MethodDescriptor)invocation.getArgumentAt(0, Descriptors.MethodDescriptor.class);
                ServerRpcController controller = (ServerRpcController)invocation.getArgumentAt(1, ServerRpcController.class);
                RpcCallback rpcCallback = (RpcCallback)invocation.getArgumentAt(4, RpcCallback.class);
                Assert.assertEquals((Object)expectedMethodName, (Object)method.getName());
                controller.setFailedOn(failureCause);
                rpcCallback.run((Object)response);
                return null;
            }
        }).when((Object)this.rpcChannel)).callMethod((Descriptors.MethodDescriptor)Matchers.any(Descriptors.MethodDescriptor.class), (RpcController)Matchers.any(RpcController.class), (Message)Matchers.any(Message.class), (Message)Matchers.any(Message.class), (RpcCallback)Matchers.any(RpcCallback.class));
    }

    @Test
    public void testPreservedExceptionOnPrepare() {
        SecureBulkLoadProtos.PrepareBulkLoadResponse response = SecureBulkLoadProtos.PrepareBulkLoadResponse.newBuilder().setBulkToken("unused").build();
        this.setupMockForMethod("PrepareBulkLoad", (Message)response, (IOException)DNRIOE);
        try {
            this.client.prepareBulkLoad(TableName.valueOf((String)"prepare"));
        }
        catch (IOException e) {
            this.checkCaughtException(e);
        }
    }

    @Test
    public void testPreservedExceptionOnCleanup() {
        SecureBulkLoadProtos.CleanupBulkLoadResponse response = SecureBulkLoadProtos.CleanupBulkLoadResponse.newBuilder().build();
        this.setupMockForMethod("CleanupBulkLoad", (Message)response, (IOException)DNRIOE);
        try {
            this.client.cleanupBulkLoad("unused");
        }
        catch (IOException e) {
            this.checkCaughtException(e);
        }
    }

    @Test
    public void testPreservedExceptionOnBulkLoad() {
        SecureBulkLoadProtos.SecureBulkLoadHFilesResponse response = SecureBulkLoadProtos.SecureBulkLoadHFilesResponse.newBuilder().setLoaded(false).build();
        this.setupMockForMethod("SecureBulkLoadHFiles", (Message)response, (IOException)DNRIOE);
        try {
            this.client.bulkLoadHFiles(Collections.emptyList(), null, "unused", new byte[0]);
        }
        catch (IOException e) {
            this.checkCaughtException(e);
        }
    }

    private void checkCaughtException(IOException e) {
        Assert.assertTrue((String)("Expected the DoNotRetryIOException to be returned without being wrapped by another IOException. Was " + StringUtils.stringifyException((Throwable)e)), (e == DNRIOE ? 1 : 0) != 0);
    }
}

