/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.BatchScanResultCache;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestBatchScanResultCache {
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private BatchScanResultCache resultCache;
    private final LinkedList<Result> cache = new LinkedList();

    @Before
    public void setUp() {
        this.resultCache = new BatchScanResultCache(this.cache, 4);
    }

    @After
    public void tearDown() {
        this.resultCache.clear();
        this.resultCache = null;
    }

    static Cell createCell(byte[] cf, int key, int cq) {
        return new KeyValue(Bytes.toBytes((int)key), cf, Bytes.toBytes((String)("cq" + cq)), Bytes.toBytes((int)key));
    }

    static Cell[] createCells(byte[] cf, int key, int numCqs) {
        Cell[] cells = new Cell[numCqs];
        for (int i = 0; i < numCqs; ++i) {
            cells[i] = TestBatchScanResultCache.createCell(cf, key, i);
        }
        return cells;
    }

    private void assertResultEquals(Result result, int key, int start, int to) {
        Assert.assertEquals((long)(to - start), (long)result.size());
        for (int i = start; i < to; ++i) {
            Assert.assertEquals((long)key, (long)Bytes.toInt((byte[])result.getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
        Assert.assertEquals((Object)(to - start == 4 ? 1 : 0), (Object)result.mayHaveMoreCellsInRow());
    }

    @Test
    public void test() throws IOException {
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, true);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        Cell[] cells1 = TestBatchScanResultCache.createCells(CF, 1, 10);
        Cell[] cells2 = TestBatchScanResultCache.createCells(CF, 2, 10);
        Cell[] cells3 = TestBatchScanResultCache.createCells(CF, 3, 10);
        this.resultCache.loadResultsToCache(new Result[]{Result.create((Cell[])Arrays.copyOf(cells1, 3), null, (boolean)false, (boolean)true)}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{Result.create((Cell[])Arrays.copyOfRange(cells1, 3, 7), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells1, 7, 10), null, (boolean)false, (boolean)true)}, false);
        Result[] results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)2L, (long)results.length);
        this.assertResultEquals(results[0], 1, 0, 4);
        this.assertResultEquals(results[1], 1, 4, 8);
        this.cache.clear();
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        this.assertResultEquals(results[0], 1, 8, 10);
        this.cache.clear();
        this.resultCache.loadResultsToCache(new Result[]{Result.create((Cell[])Arrays.copyOfRange(cells2, 0, 4), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells2, 4, 8), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells2, 8, 10), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells3, 0, 4), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells3, 4, 8), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells3, 8, 10), null, (boolean)false, (boolean)false)}, false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)6L, (long)results.length);
        this.assertResultEquals(results[0], 2, 0, 4);
        this.assertResultEquals(results[1], 2, 4, 8);
        this.assertResultEquals(results[2], 2, 8, 10);
        this.assertResultEquals(results[3], 3, 0, 4);
        this.assertResultEquals(results[4], 3, 4, 8);
        this.assertResultEquals(results[5], 3, 8, 10);
    }
}

