/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestBufferedMutatorListener
extends Configured
implements Tool {
    private static final byte[] CF1 = Bytes.toBytes((String)"cf1");
    private static final byte[] CF2 = Bytes.toBytes((String)"cf2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] argv) throws IOException {
        if (argv.length < 1) {
            System.out.println("Test the table operations with HBase 1.1 style. Usage:\nTo test in MapR DB\n\t hbase org.apache.hadoop.hbase.client.TestBufferedMutatorListener tableName MapRDB\nTo test in HBase\n\t hbase org.apache.hadoop.hbase.client.TestBufferedMutatorListener tableName HBbase");
            return -1;
        }
        TableName tableName = TableName.valueOf((String)argv[0]);
        Configuration conf = HBaseConfiguration.create();
        String defaultdb = conf.get("mapr.hbase.default.db");
        if (argv.length > 1) {
            defaultdb = argv[1];
            conf.set("mapr.hbase.default.db", defaultdb);
            System.out.println("-----Set DB " + defaultdb + "-----");
        }
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = null;
        admin = conn.getAdmin();
        BufferedMutator.ExceptionListener listener = new BufferedMutator.ExceptionListener(){

            public void onException(RetriesExhaustedWithDetailsException e, BufferedMutator mutator) throws RetriesExhaustedWithDetailsException {
                System.out.println("Listener report: Failed to send " + e.getNumExceptions() + " puts through mutator to table " + mutator.getName());
                for (int i = 0; i < e.getNumExceptions(); ++i) {
                    Row row = e.getRow(i);
                    String rstr = row.toString();
                    System.out.println("Listener report: Failed put " + i + ":" + rstr + ". Reason:");
                    e.getCause(i).printStackTrace();
                }
            }
        };
        BufferedMutatorParams params = new BufferedMutatorParams(tableName).listener(listener);
        BufferedMutator mutator = conn.getBufferedMutator(params);
        try {
            Put p1 = new Put("row1".getBytes());
            p1.addColumn(CF1, "column-1".getBytes(), "value-1".getBytes());
            mutator.mutate((Mutation)p1);
            Put p2 = new Put("row1".getBytes());
            p2.addColumn(CF2, "column-2".getBytes(), "value-2".getBytes());
            mutator.mutate((Mutation)p2);
        }
        catch (IOException e) {
            System.out.println("exception while creating/destroying Connection or BufferedMutator");
            e.printStackTrace();
        }
        finally {
            mutator.close();
            System.out.println("Mutator close successfully");
        }
        BufferedMutator mutator2 = conn.getBufferedMutator(params);
        try {
            Put p1 = new Put("row2".getBytes());
            p1.addColumn(CF1, "column-1".getBytes(), "value-3".getBytes());
            mutator2.mutate((Mutation)p1);
            Put p2 = new Put("row2".getBytes());
            p2.addColumn(CF2, "column-2".getBytes(), "value-4".getBytes());
            mutator2.mutate((Mutation)p2);
            mutator2.flush();
        }
        catch (IOException e) {
            System.out.println("exception while creating/destroying Connection or BufferedMutator");
            e.printStackTrace();
        }
        finally {
            mutator2.close();
            System.out.println("mutator2 close successfully");
            conn.close();
            System.out.println("Connection close successfully");
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Tool)new TestBufferedMutatorListener(), (String[])argv);
        System.exit(ret);
    }
}

