/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.AllowPartialScanResultCache;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.TestBatchScanResultCache;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestAllowPartialScanResultCache {
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private AllowPartialScanResultCache resultCache;
    private static final LinkedList<Result> cache = new LinkedList();

    @Before
    public void setUp() {
        this.resultCache = new AllowPartialScanResultCache(cache);
    }

    @After
    public void tearDown() {
        this.resultCache.clear();
        this.resultCache = null;
    }

    @Test
    public void test() throws IOException {
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, false);
        Assert.assertEquals((long)0L, (long)cache.size());
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, true);
        Assert.assertEquals((long)0L, (long)cache.size());
        Cell[] cells1 = TestBatchScanResultCache.createCells(CF, 1, 10);
        Cell[] cells2 = TestBatchScanResultCache.createCells(CF, 2, 10);
        this.resultCache.loadResultsToCache(new Result[]{Result.create((Cell[])Arrays.copyOf(cells1, 5), null, (boolean)false, (boolean)true)}, false);
        Result[] results1 = cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results1.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results1[0].getRow()));
        Assert.assertEquals((long)5L, (long)results1[0].rawCells().length);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results1[0].getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
        cache.clear();
        this.resultCache.loadResultsToCache(new Result[]{Result.create((Cell[])Arrays.copyOfRange(cells1, 1, 10), null, (boolean)false, (boolean)true)}, false);
        Result[] results2 = cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results2.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results2[0].getRow()));
        Assert.assertEquals((long)5L, (long)results2[0].rawCells().length);
        for (int i = 5; i < 10; ++i) {
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results2[0].getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
        cache.clear();
        this.resultCache.loadResultsToCache(new Result[]{Result.create((Cell[])cells1), Result.create((Cell[])cells2)}, false);
        Result[] results3 = cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results3.length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results3[0].getRow()));
        Assert.assertEquals((long)10L, (long)results3[0].rawCells().length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results3[0].getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
    }
}

