/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCleanupAfterKill
extends ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestCleanupAfterKill.class);

    @BeforeEach
    public void setup() throws Exception {
        File tmpYarnDir = new File("target", "tmp");
        FileUtils.deleteQuietly((File)tmpYarnDir);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.shutdown();
    }

    @Test
    @Timeout(value=200000L)
    void testRegistryCleanedOnLifetimeExceeded() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestCleanupAfterKill.createClient((Configuration)this.getConf());
        Service exampleApp = TestCleanupAfterKill.createExampleApplication();
        exampleApp.setLifetime(Long.valueOf(30L));
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        String serviceZKPath = RegistryUtils.servicePath((String)RegistryUtils.currentUser(), (String)"yarn-service", (String)exampleApp.getName());
        Assertions.assertTrue((boolean)this.getCuratorService().zkPathExists(serviceZKPath), (String)"Registry ZK service path doesn't exist");
        ApplicationId exampleAppId = ApplicationId.fromString((String)exampleApp.getId());
        GenericTestUtils.waitFor(() -> {
            try {
                ApplicationReport ar = client.getYarnClient().getApplicationReport(exampleAppId);
                return ar.getYarnApplicationState() == YarnApplicationState.KILLED;
            }
            catch (IOException | YarnException e) {
                throw new RuntimeException("while waiting", e);
            }
        }, (long)2000L, (long)200000L);
        Assertions.assertFalse((boolean)this.getCuratorService().zkPathExists(serviceZKPath), (String)"Registry ZK service path still exists after killed");
        LOG.info("Destroy the service");
        Assertions.assertEquals((int)0, (int)client.actionDestroy(exampleApp.getName()));
    }
}

