/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.client.ApiServiceClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestApiServiceClient {
    private static ApiServiceClient asc;
    private static ApiServiceClient badAsc;
    private static Server server;

    @BeforeAll
    public static void setup() throws Exception {
        server = new Server(8088);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(20);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/app");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(TestServlet.class), "/*");
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.webapp.address", "localhost:8088");
        asc = new ApiServiceClient();
        asc.serviceInit(conf);
        Configuration conf2 = new Configuration();
        conf2.set("yarn.resourcemanager.webapp.address", "localhost:8089");
        badAsc = new ApiServiceClient();
        badAsc.serviceInit(conf2);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        server.stop();
    }

    @Test
    void testGetRMWebAddress() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1");
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "localhost:0");
        ApiServiceClient asc1 = new ApiServiceClient(conf);
        boolean exceptionCaught = false;
        String diagnosticsMsg = null;
        try {
            String string = asc1.getRMWebAddress();
        }
        catch (IOException e) {
            exceptionCaught = true;
            diagnosticsMsg = e.getMessage();
        }
        Assertions.assertTrue((boolean)exceptionCaught, (String)"ApiServiceClient failed to throw exception");
        Assertions.assertTrue((boolean)diagnosticsMsg.contains("Error connecting to localhost:0"), (String)"Exception Message does not match");
    }

    @Test
    void testLaunch() {
        String fileName = "target/test-classes/example-app.json";
        String appName = "example-app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = asc.actionLaunch(fileName, appName, Long.valueOf(lifetime), queue);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testBadLaunch() {
        String fileName = "unknown_file";
        String appName = "unknown_app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = badAsc.actionLaunch(fileName, appName, Long.valueOf(lifetime), queue);
            Assertions.assertEquals((int)56, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testStatus() {
        String appName = "nonexistent-app";
        try {
            String result = asc.getStatusString(appName);
            Assertions.assertEquals((Object)(" Service " + appName + " not found"), (Object)result, (String)"Status reponse don't match");
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testStop() {
        String appName = "example-app";
        try {
            int result = asc.actionStop(appName);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testBadStop() {
        String appName = "unknown_app";
        try {
            int result = badAsc.actionStop(appName);
            Assertions.assertEquals((int)56, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testStart() {
        String appName = "example-app";
        try {
            int result = asc.actionStart(appName);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testBadStart() {
        String appName = "unknown_app";
        try {
            int result = badAsc.actionStart(appName);
            Assertions.assertEquals((int)56, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testSave() {
        String fileName = "target/test-classes/example-app.json";
        String appName = "example-app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = asc.actionSave(fileName, appName, Long.valueOf(lifetime), queue);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testBadSave() {
        String fileName = "unknown_file";
        String appName = "unknown_app";
        long lifetime = 3600L;
        String queue = "default";
        try {
            int result = badAsc.actionSave(fileName, appName, Long.valueOf(lifetime), queue);
            Assertions.assertEquals((int)56, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testFlex() {
        String appName = "example-app";
        HashMap componentCounts = new HashMap();
        try {
            int result = asc.actionFlex(appName, componentCounts);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testBadFlex() {
        String appName = "unknown_app";
        HashMap componentCounts = new HashMap();
        try {
            int result = badAsc.actionFlex(appName, componentCounts);
            Assertions.assertEquals((int)56, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testDestroy() {
        String appName = "example-app";
        try {
            int result = asc.actionDestroy(appName);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testBadDestroy() {
        String appName = "unknown_app";
        try {
            int result = badAsc.actionDestroy(appName);
            Assertions.assertEquals((int)56, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testInitiateServiceUpgrade() {
        String appName = "example-app";
        String upgradeFileName = "target/test-classes/example-app.json";
        try {
            int result = asc.initiateUpgrade(appName, upgradeFileName, false);
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testInstancesUpgrade() {
        String appName = "example-app";
        try {
            int result = asc.actionUpgradeInstances(appName, (List)Lists.newArrayList((Object[])new String[]{"comp-1", "comp-2"}));
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testComponentsUpgrade() {
        String appName = "example-app";
        try {
            int result = asc.actionUpgradeComponents(appName, (List)Lists.newArrayList((Object[])new String[]{"comp"}));
            Assertions.assertEquals((int)0, (int)result);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
    }

    @Test
    void testNoneSecureApiClient() throws IOException {
        String url = asc.getServicePath("/foobar");
        Assertions.assertTrue((boolean)url.contains("user.name"), (String)"User.name flag is missing in service path.");
        Assertions.assertTrue((boolean)url.contains(System.getProperty("user.name")), (String)"User.name flag is not matching JVM user.");
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            System.out.println("Get was called");
            if (req.getPathInfo() != null && req.getPathInfo().contains("nonexistent-app")) {
                resp.setStatus(404);
            } else {
                resp.setStatus(200);
            }
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }
    }
}

