/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.service.ServiceClientTest;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.api.records.ServiceStatus;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.conf.RestApiConstants;
import org.apache.hadoop.yarn.service.webapp.ApiServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestApiServer {
    private ApiServer apiServer;
    private HttpServletRequest request;
    private ServiceClientTest mockServerClient;

    @Before
    public void setup() throws Exception {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)System.getProperty("user.name"));
        this.mockServerClient = new ServiceClientTest();
        Configuration conf = new Configuration();
        conf.set("yarn.api-service.service.client.class", ServiceClientTest.class.getName());
        this.apiServer = new ApiServer(conf);
        this.apiServer.setServiceClient((ServiceClient)this.mockServerClient);
    }

    @After
    public void teardown() {
        this.mockServerClient.forceStop();
    }

    @Test
    public void testPathAnnotation() {
        Assert.assertNotNull((Object)this.apiServer.getClass().getAnnotation(Path.class));
        Assert.assertTrue((String)"The controller has the annotation Path", (boolean)this.apiServer.getClass().isAnnotationPresent(Path.class));
        Path path = this.apiServer.getClass().getAnnotation(Path.class);
        Assert.assertEquals((String)"The path has /v1 annotation", (Object)"/v1", (Object)path.value());
    }

    @Test
    public void testGetVersion() {
        Response actual = this.apiServer.getVersion();
        Assert.assertEquals((String)"Version number is", (long)Response.ok().build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadCreateService() {
        Service service = new Service();
        Response actual = this.apiServer.createService(this.request, service);
        Assert.assertEquals((String)"Create service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testGoodCreateService() throws Exception {
        String json = "{\"auths\": {\"https://index.docker.io/v1/\": {\"auth\": \"foobarbaz\"},\"registry.example.com\": {\"auth\": \"bazbarfoo\"}}}";
        File dockerTmpDir = new File("target", "docker-tmp");
        FileUtils.deleteQuietly((File)dockerTmpDir);
        dockerTmpDir.mkdirs();
        String dockerConfig = dockerTmpDir + "/config.json";
        BufferedWriter bw = new BufferedWriter(new FileWriter(dockerConfig));
        bw.write(json);
        bw.close();
        Service service = ServiceClientTest.buildGoodService();
        Response actual = this.apiServer.createService(this.request, service);
        Assert.assertEquals((String)"Create service is ", (long)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testInternalServerErrorDockerClientConfigMissingCreateService() {
        Service service = new Service();
        service.setName("jenkins");
        service.setVersion("v1");
        service.setDockerClientConfig("/does/not/exist/config.json");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.createService(this.request, service);
        Assert.assertEquals((String)"Create service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadGetService() {
        String serviceName = "nonexistent-jenkins";
        Response actual = this.apiServer.getService(this.request, "nonexistent-jenkins");
        Assert.assertEquals((String)"Get service is ", (long)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (long)actual.getStatus());
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Response code don't match", (Object)RestApiConstants.ERROR_CODE_APP_NAME_INVALID, (Object)serviceStatus.getCode());
        Assert.assertEquals((String)"Response diagnostics don't match", (Object)"Service nonexistent-jenkins not found", (Object)serviceStatus.getDiagnostics());
    }

    @Test
    public void testBadGetService2() {
        Response actual = this.apiServer.getService(this.request, null);
        Assert.assertEquals((String)"Get service is ", (long)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (long)actual.getStatus());
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Response code don't match", (Object)RestApiConstants.ERROR_CODE_APP_NAME_INVALID, (Object)serviceStatus.getCode());
        Assert.assertEquals((String)"Response diagnostics don't match", (Object)"Service name cannot be null.", (Object)serviceStatus.getDiagnostics());
    }

    @Test
    public void testGoodGetService() {
        Response actual = this.apiServer.getService(this.request, "jenkins");
        Assert.assertEquals((String)"Get service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadDeleteService() {
        Response actual = this.apiServer.deleteService(this.request, "no-jenkins");
        Assert.assertEquals((String)"Delete service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadDeleteService2() {
        Response actual = this.apiServer.deleteService(this.request, null);
        Assert.assertEquals((String)"Delete service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadDeleteService3() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins-doesn't-exist");
        Assert.assertEquals((String)"Delete service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadDeleteService4() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins-error-cleaning-registry");
        Assert.assertEquals((String)"Delete service is ", (long)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testGoodDeleteService() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins");
        Assert.assertEquals((String)"Delete service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testDeleteStoppedService() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins-already-stopped");
        Assert.assertEquals((String)"Delete service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testDecreaseContainerAndStop() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(0L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assert.assertEquals((String)"update service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadDecreaseContainerAndStop() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("no-jenkins");
        c.setNumberOfContainers(Long.valueOf(-1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assert.assertEquals((String)"flex service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testIncreaseContainersAndStart() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(2L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assert.assertEquals((String)"flex service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadStartServices() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(2L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assert.assertEquals((String)"start service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testGoodStartServices() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(2L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assert.assertEquals((String)"start service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadStopServices() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("no-jenkins");
        c.setNumberOfContainers(Long.valueOf(-1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assert.assertEquals((String)"stop service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testGoodStopServices() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("jenkins");
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assert.assertEquals((String)"stop service is ", (long)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testBadSecondStopServices() throws Exception {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("jenkins-second-stop");
        System.out.println("before second stop");
        Response actual = this.apiServer.updateService(this.request, "jenkins-second-stop", service);
        Assert.assertEquals((String)"stop service should have thrown 400 Bad Request: ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Stop service should have failed with service already stopped", (Object)"Service jenkins-second-stop is already stopped", (Object)serviceStatus.getDiagnostics());
    }

    @Test
    public void testUpdateService() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("no-jenkins");
        c.setNumberOfContainers(Long.valueOf(-1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assert.assertEquals((String)"update service is ", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testUpdateComponent() {
        Response actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", null);
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Update component should have failed with 400 bad request", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
        Assert.assertEquals((String)"Update component should have failed with no data error", (Object)"No component data provided", (Object)serviceStatus.getDiagnostics());
        Component comp = new Component();
        actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", comp);
        serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Update component should have failed with 400 bad request", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
        Assert.assertEquals((String)"Update component should have failed with no count error", (Object)"No container count provided", (Object)serviceStatus.getDiagnostics());
        comp.setNumberOfContainers(Long.valueOf(-1L));
        actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", comp);
        serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Update component should have failed with 400 bad request", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
        Assert.assertEquals((String)"Update component should have failed with no count error", (Object)"Invalid number of containers specified -1", (Object)serviceStatus.getDiagnostics());
        comp.setName("jenkins-slave");
        comp.setNumberOfContainers(Long.valueOf(1L));
        actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", comp);
        serviceStatus = (ServiceStatus)actual.getEntity();
        Assert.assertEquals((String)"Update component should have failed with 400 bad request", (long)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (long)actual.getStatus());
        Assert.assertEquals((String)"Update component should have failed with component name mismatch error", (Object)"Component name in the request object (jenkins-slave) does not match that in the URI path (jenkins-master)", (Object)serviceStatus.getDiagnostics());
    }

    @Test
    public void testInitiateUpgrade() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        goodService.setVersion("v2");
        goodService.setState(ServiceState.UPGRADING);
        Response actual = this.apiServer.updateService(this.request, goodService.getName(), goodService);
        Assert.assertEquals((String)"Initiate upgrade is ", (long)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testUpgradeSingleInstance() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        Component comp = (Component)goodService.getComponents().iterator().next();
        Container container = (Container)comp.getContainers().iterator().next();
        container.setState(ContainerState.UPGRADING);
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        Container liveContainer = (Container)((Component)serviceStatus.getComponents().iterator().next()).getContainers().iterator().next();
        liveContainer.setState(ContainerState.NEEDS_UPGRADE);
        this.mockServerClient.setExpectedInstances(Sets.newHashSet((Object[])new String[]{liveContainer.getComponentInstanceName()}));
        Response actual = this.apiServer.updateComponentInstance(this.request, goodService.getName(), comp.getName(), container.getComponentInstanceName(), container);
        Assert.assertEquals((String)"Instance upgrade is ", (long)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testUpgradeMultipleInstances() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        Component comp = (Component)goodService.getComponents().iterator().next();
        comp.getContainers().forEach(container -> container.setState(ContainerState.UPGRADING));
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        HashSet<String> expectedInstances = new HashSet<String>();
        ((Component)serviceStatus.getComponents().iterator().next()).getContainers().forEach(container -> {
            container.setState(ContainerState.NEEDS_UPGRADE);
            expectedInstances.add(container.getComponentInstanceName());
        });
        this.mockServerClient.setExpectedInstances(expectedInstances);
        Response actual = this.apiServer.updateComponentInstances(this.request, goodService.getName(), comp.getContainers());
        Assert.assertEquals((String)"Instance upgrade is ", (long)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testUpgradeComponent() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        Component comp = (Component)goodService.getComponents().iterator().next();
        comp.setState(ComponentState.UPGRADING);
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        Component liveComp = serviceStatus.getComponent(comp.getName());
        liveComp.setState(ComponentState.NEEDS_UPGRADE);
        HashSet<String> expectedInstances = new HashSet<String>();
        liveComp.getContainers().forEach(container -> {
            expectedInstances.add(container.getComponentInstanceName());
            container.setState(ContainerState.NEEDS_UPGRADE);
        });
        this.mockServerClient.setExpectedInstances(expectedInstances);
        Response actual = this.apiServer.updateComponent(this.request, goodService.getName(), comp.getName(), comp);
        Assert.assertEquals((String)"Component upgrade is ", (long)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testUpgradeMultipleComps() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        goodService.getComponents().forEach(comp -> comp.setState(ComponentState.UPGRADING));
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        HashSet<String> expectedInstances = new HashSet<String>();
        serviceStatus.getComponents().forEach(liveComp -> {
            liveComp.setState(ComponentState.NEEDS_UPGRADE);
            liveComp.getContainers().forEach(liveContainer -> {
                expectedInstances.add(liveContainer.getComponentInstanceName());
                liveContainer.setState(ContainerState.NEEDS_UPGRADE);
            });
        });
        this.mockServerClient.setExpectedInstances(expectedInstances);
        Response actual = this.apiServer.updateComponents(this.request, goodService.getName(), goodService.getComponents());
        Assert.assertEquals((String)"Component upgrade is ", (long)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (long)actual.getStatus());
    }
}

