/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCleanupAfterKill
extends ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestCleanupAfterKill.class);
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setup() throws Exception {
        File tmpYarnDir = new File("target", "tmp");
        FileUtils.deleteQuietly((File)tmpYarnDir);
    }

    @After
    public void tearDown() throws IOException {
        this.shutdown();
    }

    @Test(timeout=200000L)
    public void testRegistryCleanedOnLifetimeExceeded() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestCleanupAfterKill.createClient((Configuration)this.getConf());
        Service exampleApp = TestCleanupAfterKill.createExampleApplication();
        exampleApp.setLifetime(Long.valueOf(30L));
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        String serviceZKPath = RegistryUtils.servicePath((String)RegistryUtils.currentUser(), (String)"yarn-service", (String)exampleApp.getName());
        Assert.assertTrue((String)"Registry ZK service path doesn't exist", (boolean)this.getCuratorService().zkPathExists(serviceZKPath));
        ApplicationId exampleAppId = ApplicationId.fromString((String)exampleApp.getId());
        GenericTestUtils.waitFor(() -> {
            try {
                ApplicationReport ar = client.getYarnClient().getApplicationReport(exampleAppId);
                return ar.getYarnApplicationState() == YarnApplicationState.KILLED;
            }
            catch (IOException | YarnException e) {
                throw new RuntimeException("while waiting", e);
            }
        }, (long)2000L, (long)200000L);
        Assert.assertFalse((String)"Registry ZK service path still exists after killed", (boolean)this.getCuratorService().zkPathExists(serviceZKPath));
        LOG.info("Destroy the service");
        Assert.assertEquals((long)0L, (long)client.actionDestroy(exampleApp.getName()));
    }
}

