/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.DefaultAppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebAppProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestWebAppProxyServlet.class);
    private static Server server;
    private static int originalPort;
    private static int numberOfHeaders;
    private static final String UNKNOWN_HEADER = "Unknown-Header";
    private static boolean hasUnknownHeader;
    Configuration configuration = new Configuration();

    @BeforeAll
    public static void start() throws Exception {
        server = new Server(0);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(20);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(TestServlet.class), "/bar");
        context.addServlet(new ServletHolder(TimeOutTestServlet.class), "/timeout");
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        originalPort = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        LOG.info("Running embedded servlet container at: http://localhost:{}", (Object)originalPort);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L)
    void testWebAppProxyServlet() throws Exception {
        this.configuration.set("yarn.web-proxy.address", "localhost:9090");
        this.configuration.setInt("hadoop.http.max.threads", 10);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest();
        proxy.init(this.configuration);
        proxy.start();
        int proxyPort = ((WebAppProxyServerForTest)proxy).proxy.proxyServer.getConnectorAddress(0).getPort();
        AppReportFetcherForTest appReportFetcher = ((WebAppProxyServerForTest)proxy).proxy.appReportFetcher;
        try {
            URL emptyUrl = new URL("http://localhost:" + proxyPort + "/proxy");
            HttpURLConnection emptyProxyConn = (HttpURLConnection)emptyUrl.openConnection();
            emptyProxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)404, (int)emptyProxyConn.getResponseCode());
            URL wrongUrl = new URL("http://localhost:" + proxyPort + "/proxy/app");
            HttpURLConnection proxyConn = (HttpURLConnection)wrongUrl.openConnection();
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)proxyConn.getResponseCode());
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0");
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)proxyConn.getResponseCode());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            URL redirectUrl = new URL("http://localhost:" + proxyPort + "/proxy/redirect/application_00_0");
            proxyConn = (HttpURLConnection)redirectUrl.openConnection();
            proxyConn.setInstanceFollowRedirects(false);
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)302, (int)proxyConn.getResponseCode(), (String)"The proxy returned an unexpected status code rather thanredirecting the connection (302)");
            String expected = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.configuration) + "/cluster/failure/application_00_0";
            String redirect = proxyConn.getHeaderField("Location");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)redirect, (String)"The proxy did not redirect the connection to the failure page of the RM");
            appReportFetcher.answer = 1;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)404, (int)proxyConn.getResponseCode());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.answer = 4;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)404, (int)proxyConn.getResponseCode());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.answer = 2;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)proxyConn.getResponseCode());
            String s = this.readInputStream(proxyConn.getInputStream());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)s.contains("to continue to an Application Master web interface owned by"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)s.contains("WARNING: The following page may not be safe!"));
            appReportFetcher.answer = 3;
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)proxyConn.getResponseCode());
            appReportFetcher.answer = 5;
            URL clientUrl = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0/test/tez?x=y&h=p");
            proxyConn = (HttpURLConnection)clientUrl.openConnection();
            proxyConn.connect();
            LOG.info("" + proxyConn.getURL());
            LOG.info("ProxyConn.getHeaderField(): " + proxyConn.getHeaderField("Location"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)("http://localhost:" + originalPort + "/foo/bar/test/tez?a=b&x=y&h=p#main"), (Object)proxyConn.getURL().toString());
        }
        finally {
            proxy.close();
        }
    }

    @Test
    void testWebAppProxyConnectionTimeout() throws IOException, ServletException {
        org.junit.jupiter.api.Assertions.assertThrows(SocketTimeoutException.class, () -> {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"dr.who");
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/application_00_0");
            Mockito.when((Object)request.getHeaderNames()).thenReturn(Collections.emptyEnumeration());
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.getOutputStream()).thenReturn(null);
            WebAppProxyServlet servlet = new WebAppProxyServlet();
            YarnConfiguration conf = new YarnConfiguration();
            conf.setBoolean("yarn.resourcemanager.proxy.timeout.enabled", true);
            conf.setInt("yarn.resourcemanager.proxy.connection.timeout", 1000);
            servlet.setConf(conf);
            ServletConfig config = (ServletConfig)Mockito.mock(ServletConfig.class);
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
            AppReportFetcherForTest appReportFetcher = new AppReportFetcherForTest((Configuration)new YarnConfiguration());
            Mockito.when((Object)config.getServletContext().getAttribute("AppUrlFetcher")).thenReturn((Object)appReportFetcher);
            appReportFetcher.answer = 7;
            servlet.init(config);
            servlet.doGet(request, response);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L)
    void testAppReportForEmptyTrackingUrl() throws Exception {
        this.configuration.set("yarn.web-proxy.address", "localhost:9090");
        this.configuration.setInt("hadoop.http.max.threads", 10);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest();
        proxy.init(this.configuration);
        proxy.start();
        int proxyPort = ((WebAppProxyServerForTest)proxy).proxy.proxyServer.getConnectorAddress(0).getPort();
        AppReportFetcherForTest appReportFetcher = ((WebAppProxyServerForTest)proxy).proxy.appReportFetcher;
        try {
            this.configuration.setBoolean("yarn.timeline-service.generic-application-history.enabled", false);
            ApplicationId app = ApplicationId.newInstance((long)0L, (int)0);
            appReportFetcher.answer = 6;
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/" + app.toString());
            HttpURLConnection proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            try {
                proxyConn.getResponseCode();
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            String appAddressInRm = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.configuration) + "/cluster/app/" + app.toString();
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyConn.getURL().toString(), (Object)appAddressInRm, (String)"Webapp proxy servlet should have redirected to RM");
            this.configuration.setBoolean("yarn.timeline-service.generic-application-history.enabled", true);
            ((WebAppProxyServerForTest)proxy).proxy.appReportFetcher.setAhsAppPageUrlBase(this.configuration);
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            try {
                proxyConn.getResponseCode();
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            String appAddressInAhs = WebAppUtils.getHttpSchemePrefix((Configuration)this.configuration) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)this.configuration) + "/applicationhistory/app/" + app.toString();
            org.junit.jupiter.api.Assertions.assertEquals((Object)proxyConn.getURL().toString(), (Object)appAddressInAhs, (String)"Webapp proxy servlet should have redirected to AHS");
        }
        finally {
            proxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L)
    void testWebAppProxyPassThroughHeaders() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("yarn.web-proxy.address", "localhost:9091");
        configuration.setInt("hadoop.http.max.threads", 10);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest();
        proxy.init(configuration);
        proxy.start();
        int proxyPort = ((WebAppProxyServerForTest)proxy).proxy.proxyServer.getConnectorAddress(0).getPort();
        try {
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/application_00_1");
            HttpURLConnection proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.addRequestProperty("Origin", "http://www.someurl.com");
            proxyConn.addRequestProperty("Access-Control-Request-Method", "GET");
            proxyConn.addRequestProperty("Access-Control-Request-Headers", "Authorization");
            proxyConn.addRequestProperty(UNKNOWN_HEADER, "unknown");
            Assertions.assertThat(proxyConn.getRequestProperties()).hasSize(4);
            proxyConn.connect();
            org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)proxyConn.getResponseCode());
            org.junit.jupiter.api.Assertions.assertEquals((int)numberOfHeaders, (int)9);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)hasUnknownHeader);
        }
        finally {
            proxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L)
    void testWebAppProxyServerMainMethod() throws Exception {
        WebAppProxyServer mainServer = null;
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.web-proxy.address", "localhost:9099");
        try {
            mainServer = WebAppProxyServer.startServer((Configuration)conf);
            int counter = 20;
            URL wrongUrl = new URL("http://localhost:9099/proxy/app");
            HttpURLConnection proxyConn = null;
            while (counter > 0) {
                --counter;
                try {
                    proxyConn = (HttpURLConnection)wrongUrl.openConnection();
                    proxyConn.connect();
                    proxyConn.getResponseCode();
                    counter = 0;
                }
                catch (Exception e) {
                    Thread.sleep(100L);
                }
            }
            org.junit.jupiter.api.Assertions.assertNotNull(proxyConn);
            org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)proxyConn.getResponseCode());
        }
        finally {
            if (mainServer != null) {
                mainServer.stop();
            }
        }
    }

    @Test
    @Timeout(value=5000L)
    void testCheckHttpsStrictAndNotProvided() throws Exception {
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter sw = new StringWriter();
        Mockito.when((Object)resp.getWriter()).thenReturn((Object)new PrintWriter(sw));
        YarnConfiguration conf = new YarnConfiguration();
        URI httpLink = new URI("http://foo.com");
        URI httpsLink = new URI("https://foo.com");
        conf.set("yarn.resourcemanager.application-https.policy", "NONE");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WebAppProxyServlet.checkHttpsStrictAndNotProvided((HttpServletResponse)resp, (URI)httpsLink, (YarnConfiguration)conf));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sw.toString());
        ((HttpServletResponse)Mockito.verify((Object)resp, (VerificationMode)Mockito.times((int)0))).setContentType((String)Mockito.any());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WebAppProxyServlet.checkHttpsStrictAndNotProvided((HttpServletResponse)resp, (URI)httpLink, (YarnConfiguration)conf));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sw.toString());
        ((HttpServletResponse)Mockito.verify((Object)resp, (VerificationMode)Mockito.times((int)0))).setContentType((String)Mockito.any());
        conf.set("yarn.resourcemanager.application-https.policy", "LENIENT");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WebAppProxyServlet.checkHttpsStrictAndNotProvided((HttpServletResponse)resp, (URI)httpsLink, (YarnConfiguration)conf));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sw.toString());
        ((HttpServletResponse)Mockito.verify((Object)resp, (VerificationMode)Mockito.times((int)0))).setContentType((String)Mockito.any());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WebAppProxyServlet.checkHttpsStrictAndNotProvided((HttpServletResponse)resp, (URI)httpLink, (YarnConfiguration)conf));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sw.toString());
        ((HttpServletResponse)Mockito.verify((Object)resp, (VerificationMode)Mockito.times((int)0))).setContentType((String)Mockito.any());
        conf.set("yarn.resourcemanager.application-https.policy", "STRICT");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WebAppProxyServlet.checkHttpsStrictAndNotProvided((HttpServletResponse)resp, (URI)httpsLink, (YarnConfiguration)conf));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)sw.toString());
        ((HttpServletResponse)Mockito.verify((Object)resp, (VerificationMode)Mockito.times((int)0))).setContentType((String)Mockito.any());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)WebAppProxyServlet.checkHttpsStrictAndNotProvided((HttpServletResponse)resp, (URI)httpLink, (YarnConfiguration)conf));
        String s = sw.toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)s.contains("HTTPS must be used"), (String)("Was expecting an HTML page explaining that an HTTPS tracking url must be used but found " + s));
        ((HttpServletResponse)Mockito.verify((Object)resp, (VerificationMode)Mockito.times((int)1))).setContentType("text/html; charset=UTF-8");
    }

    private String readInputStream(InputStream input) throws Exception {
        int read;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((read = input.read(buffer)) >= 0) {
            data.write(buffer, 0, read);
        }
        return new String(data.toByteArray(), StandardCharsets.UTF_8);
    }

    private boolean isResponseCookiePresent(HttpURLConnection proxyConn, String expectedName, String expectedValue) {
        Map<String, List<String>> headerFields = proxyConn.getHeaderFields();
        List<String> cookiesHeader = headerFields.get("Set-Cookie");
        if (cookiesHeader != null) {
            for (String cookie : cookiesHeader) {
                HttpCookie c = HttpCookie.parse(cookie).get(0);
                if (!c.getName().equals(expectedName) || !c.getValue().equals(expectedValue)) continue;
                return true;
            }
        }
        return false;
    }

    @AfterAll
    public static void stop() throws Exception {
        try {
            server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        originalPort = 0;
        numberOfHeaders = 0;
        hasUnknownHeader = false;
    }

    private class AppReportFetcherForTest
    extends DefaultAppReportFetcher {
        int answer;
        private String ahsAppPageUrlBase;

        public AppReportFetcherForTest(Configuration conf) {
            super(conf);
            this.answer = 0;
            this.ahsAppPageUrlBase = null;
        }

        public AppReportFetcher.FetchedAppReport getApplicationReport(ApplicationId appId) throws YarnException {
            if (this.answer == 0) {
                return this.getDefaultApplicationReport(appId);
            }
            if (this.answer == 1) {
                return null;
            }
            if (this.answer == 2) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setUser("user");
                return result;
            }
            if (this.answer == 3) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setYarnApplicationState(YarnApplicationState.KILLED);
                return result;
            }
            if (this.answer == 4) {
                throw new ApplicationNotFoundException("Application is not found");
            }
            if (this.answer == 5) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setOriginalTrackingUrl("localhost:" + originalPort + "/foo/bar?a=b#main");
                result.getApplicationReport().setYarnApplicationState(YarnApplicationState.FINISHED);
                return result;
            }
            if (this.answer == 6) {
                return this.getDefaultApplicationReport(appId, false);
            }
            if (this.answer == 7) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setOriginalTrackingUrl("localhost:" + originalPort + "/foo/timeout?a=b#main");
                return result;
            }
            return null;
        }

        private AppReportFetcher.FetchedAppReport getDefaultApplicationReport(ApplicationId appId, boolean isTrackingUrl) {
            ApplicationReportPBImpl result = new ApplicationReportPBImpl();
            result.setApplicationId(appId);
            result.setYarnApplicationState(YarnApplicationState.RUNNING);
            result.setUser("dr.who");
            if (isTrackingUrl) {
                result.setOriginalTrackingUrl("localhost:" + originalPort + "/foo/bar");
            }
            AppReportFetcher.FetchedAppReport fetchedReport = TestWebAppProxyServlet.this.configuration.getBoolean("yarn.timeline-service.generic-application-history.enabled", false) ? new AppReportFetcher.FetchedAppReport((ApplicationReport)result, AppReportFetcher.AppReportSource.AHS) : new AppReportFetcher.FetchedAppReport((ApplicationReport)result, AppReportFetcher.AppReportSource.RM);
            return fetchedReport;
        }

        private AppReportFetcher.FetchedAppReport getDefaultApplicationReport(ApplicationId appId) {
            return this.getDefaultApplicationReport(appId, true);
        }

        @VisibleForTesting
        public String getAhsAppPageUrlBase() {
            return this.ahsAppPageUrlBase != null ? this.ahsAppPageUrlBase : super.getAhsAppPageUrlBase();
        }

        @VisibleForTesting
        public void setAhsAppPageUrlBase(Configuration conf) {
            this.ahsAppPageUrlBase = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf), "applicationhistory", "app"});
        }
    }

    private class WebAppProxyForTest
    extends WebAppProxy {
        HttpServer2 proxyServer;
        AppReportFetcherForTest appReportFetcher;

        private WebAppProxyForTest() {
        }

        protected void serviceStart() throws Exception {
            Configuration conf = this.getConfig();
            String bindAddress = conf.get("yarn.web-proxy.address");
            bindAddress = StringUtils.split((String)bindAddress, (char)':')[0];
            AccessControlList acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
            this.proxyServer = new HttpServer2.Builder().setName("proxy").addEndpoint(URI.create(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + bindAddress + ":0")).setFindPort(true).setConf(conf).setACL(acl).build();
            this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            this.appReportFetcher = new AppReportFetcherForTest(conf);
            this.proxyServer.setAttribute("AppUrlFetcher", (Object)this.appReportFetcher);
            this.proxyServer.setAttribute("IsSecurityEnabled", (Object)Boolean.TRUE);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)conf);
            String[] proxyParts = proxy.split(":");
            String proxyHost = proxyParts[0];
            this.proxyServer.setAttribute("proxyHost", (Object)proxyHost);
            this.proxyServer.start();
            LOG.info("Proxy server is started at port {}", (Object)this.proxyServer.getConnectorAddress(0).getPort());
        }
    }

    private class WebAppProxyServerForTest
    extends CompositeService {
        private WebAppProxyForTest proxy;

        public WebAppProxyServerForTest() {
            super(WebAppProxyServer.class.getName());
            this.proxy = null;
        }

        public synchronized void serviceInit(Configuration conf) throws Exception {
            this.proxy = new WebAppProxyForTest();
            this.addService((Service)this.proxy);
            super.serviceInit(conf);
        }
    }

    public static class TimeOutTestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOG.warn("doGet() interrupted", (Throwable)e);
                resp.setStatus(400);
                return;
            }
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            int numHeaders = 0;
            hasUnknownHeader = false;
            Enumeration names = req.getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                if (headerName.equals(TestWebAppProxyServlet.UNKNOWN_HEADER)) {
                    hasUnknownHeader = true;
                }
                ++numHeaders;
            }
            numberOfHeaders = numHeaders;
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ServletInputStream is = req.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            int c = is.read();
            while (c > -1) {
                os.write(c);
                c = is.read();
            }
            is.close();
            os.close();
            resp.setStatus(200);
        }
    }
}

