/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.webproxy.ProxyCA;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestProxyCA {
    @Test
    public void testInit() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNull((Object)proxyCA.getHostnameVerifier());
        proxyCA.init();
        Assert.assertNotNull((Object)proxyCA.getCaCert());
        Assert.assertNotNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNotNull((Object)proxyCA.getHostnameVerifier());
    }

    @Test
    public void testInit2Null() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNull((Object)proxyCA.getHostnameVerifier());
        proxyCA.init(null, null);
        Assert.assertNotNull((Object)proxyCA.getCaCert());
        Assert.assertNotNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNotNull((Object)proxyCA.getHostnameVerifier());
    }

    @Test
    public void testInit2Mismatch() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNull((Object)proxyCA.getHostnameVerifier());
        CertKeyPair pair1 = this.createCertAndKeyPair();
        CertKeyPair pair2 = this.createCertAndKeyPair();
        Assert.assertNotEquals((Object)pair1.getCert(), (Object)pair2.getCert());
        Assert.assertNotEquals((Object)pair1.getKeyPair().getPrivate(), (Object)pair2.getKeyPair().getPrivate());
        Assert.assertNotEquals((Object)pair1.getKeyPair().getPublic(), (Object)pair2.getKeyPair().getPublic());
        proxyCA.init(pair1.getCert(), pair2.getKeyPair().getPrivate());
        Assert.assertNotNull((Object)proxyCA.getCaCert());
        Assert.assertNotNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNotNull((Object)proxyCA.getHostnameVerifier());
        Assert.assertNotEquals((Object)proxyCA.getCaCert(), (Object)pair1.getCert());
        Assert.assertNotEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)pair2.getKeyPair().getPrivate());
        Assert.assertNotEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)pair2.getKeyPair().getPublic());
    }

    @Test
    public void testInit2Invalid() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNull((Object)proxyCA.getHostnameVerifier());
        X509Certificate certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        PrivateKey privateKey = (PrivateKey)Mockito.mock(PrivateKey.class);
        try {
            proxyCA.init(certificate, privateKey);
            Assert.fail((String)"Expected InvalidKeyException");
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
    }

    @Test
    public void testInit2() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        Assert.assertNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNull((Object)proxyCA.getHostnameVerifier());
        CertKeyPair pair = this.createCertAndKeyPair();
        proxyCA.init(pair.getCert(), pair.getKeyPair().getPrivate());
        Assert.assertEquals((Object)pair.getCert(), (Object)proxyCA.getCaCert());
        Assert.assertEquals((Object)pair.getKeyPair().getPrivate(), (Object)proxyCA.getCaKeyPair().getPrivate());
        Assert.assertEquals((Object)pair.getKeyPair().getPublic(), (Object)proxyCA.getCaKeyPair().getPublic());
        Assert.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assert.assertNotNull((Object)proxyCA.getHostnameVerifier());
    }

    @Test
    public void testCreateChildKeyStore() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        byte[] keystoreBytes = proxyCA.createChildKeyStore(appId, "password");
        KeyStore keyStore = KeyStoreTestUtil.bytesToKeyStore((byte[])keystoreBytes, (String)"password");
        Assert.assertEquals((long)1L, (long)keyStore.size());
        Certificate[] certChain = keyStore.getCertificateChain("server");
        Assert.assertEquals((long)2L, (long)certChain.length);
        X509Certificate caCert = (X509Certificate)certChain[1];
        X509Certificate cert = (X509Certificate)certChain[0];
        Assert.assertEquals((Object)caCert.getSubjectX500Principal().toString(), (Object)cert.getIssuerDN().toString());
        Assert.assertEquals((Object)new X500Principal("CN=" + appId), (Object)cert.getSubjectX500Principal());
        Assert.assertFalse((String)("Found multiple fields in X500 Principal, when there should have only been one: " + cert.getSubjectX500Principal()), (boolean)cert.getSubjectX500Principal().toString().contains(","));
        Assert.assertEquals((Object)"SHA512withRSA", (Object)cert.getSigAlgName());
        Assert.assertEquals((Object)cert.getNotBefore(), (Object)cert.getNotAfter());
        Assert.assertTrue((String)("Expected certificate to be expired but was not: " + cert.getNotAfter()), (boolean)cert.getNotAfter().before(new Date()));
        Assert.assertEquals((Object)new X500Principal("CN=" + appId).toString(), (Object)cert.getSubjectDN().toString());
        Key privateKey = keyStore.getKey("server", "password".toCharArray());
        Assert.assertEquals((Object)"RSA", (Object)privateKey.getAlgorithm());
        Assert.assertEquals((long)-1L, (long)cert.getBasicConstraints());
        PublicKey caPublicKey = caCert.getPublicKey();
        cert.verify(caPublicKey);
        this.checkCACert(caCert);
        Assert.assertEquals((Object)proxyCA.getCaCert(), (Object)caCert);
        caCert.verify(caPublicKey);
        PrivateKey caPrivateKey = proxyCA.getX509KeyManager().getPrivateKey(null);
        this.checkPrivatePublicKeys(caPrivateKey, caPublicKey);
        Assert.assertEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)caPublicKey);
        Assert.assertEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)caPrivateKey);
    }

    @Test
    public void testGetChildTrustStore() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        byte[] truststoreBytes = proxyCA.getChildTrustStore("password");
        KeyStore truststore = KeyStoreTestUtil.bytesToKeyStore((byte[])truststoreBytes, (String)"password");
        Assert.assertEquals((long)1L, (long)truststore.size());
        X509Certificate caCert = (X509Certificate)truststore.getCertificate("client");
        this.checkCACert(caCert);
        Assert.assertEquals((Object)proxyCA.getCaCert(), (Object)caCert);
        PublicKey caPublicKey = caCert.getPublicKey();
        caCert.verify(caPublicKey);
        PrivateKey caPrivateKey = proxyCA.getX509KeyManager().getPrivateKey(null);
        this.checkPrivatePublicKeys(caPrivateKey, caPublicKey);
        Assert.assertEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)caPublicKey);
        Assert.assertEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)caPrivateKey);
    }

    @Test
    public void testGenerateKeyStorePassword() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HashSet<String> passwords = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            String password = proxyCA.generateKeyStorePassword();
            Assert.assertEquals((long)16L, (long)password.length());
            for (char c : password.toCharArray()) {
                Assert.assertFalse((String)("Found character '" + c + "' in password '" + password + "' which is outside of the expected range"), (c < ' ' ? 1 : 0) != 0);
                Assert.assertFalse((String)("Found character '" + c + "' in password '" + password + "' which is outside of the expected range"), (c > 'z' ? 1 : 0) != 0);
            }
            Assert.assertFalse((String)("Password " + password + " was generated twice, which is _extremely_ unlikely and shouldn't practically happen: " + passwords), (boolean)passwords.contains(password));
            passwords.add(password);
        }
    }

    @Test
    public void testCreateTrustManagerDefaultTrustManager() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        Mockito.when((Object)defaultTrustManager.getAcceptedIssuers()).thenReturn((Object)new X509Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")});
        Assert.assertArrayEquals((Object[])defaultTrustManager.getAcceptedIssuers(), (Object[])trustManager.getAcceptedIssuers());
        trustManager.checkClientTrusted(null, null);
    }

    @Test
    public void testCreateTrustManagerYarnCert() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(appId, "password"), (String)"password").getCertificateChain("server"));
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
    }

    @Test
    public void testCreateTrustManagerWrongApp() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(appId2, "password"), (String)"password").getCertificateChain("server"));
        try {
            trustManager.checkServerTrusted(certChain, "RSA");
            Assert.fail((String)"Should have thrown a CertificateException, but did not");
        }
        catch (CertificateException ce) {
            Assert.assertEquals((Object)("Expected to find Subject X500 Principal with CN=" + appId + " but found CN=" + appId2), (Object)ce.getMessage());
        }
    }

    @Test
    public void testCreateTrustManagerWrongRM() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        ProxyCA proxyCA2 = new ProxyCA();
        proxyCA2.init();
        X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA2.createChildKeyStore(appId, "password"), (String)"password").getCertificateChain("server"));
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
    }

    @Test
    public void testCreateTrustManagerRealCert() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        X509Certificate[] certChain = new X509Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
        certChain = new X509Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA"), KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
    }

    @Test
    public void testCreateTrustManagerExceptions() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        for (Exception e : new Exception[]{new CertificateException(), new NoSuchAlgorithmException(), new InvalidKeyException(), new SignatureException(), new NoSuchProviderException()}) {
            X509Certificate cert;
            X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(appId, "password"), (String)"password").getCertificateChain("server"));
            certChain[0] = cert = (X509Certificate)Mockito.spy((Object)certChain[0]);
            ((X509Certificate)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)certChain[0])).verify((PublicKey)Mockito.any());
            ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
            trustManager.checkServerTrusted(certChain, "RSA");
            ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
        }
    }

    @Test
    public void testCreateKeyManager() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509KeyManager keyManager = proxyCA.getX509KeyManager();
        Assert.assertArrayEquals((Object[])new String[]{"client"}, (Object[])keyManager.getClientAliases(null, null));
        Assert.assertEquals((Object)"client", (Object)keyManager.chooseClientAlias(null, null, null));
        Assert.assertNull((Object)keyManager.getServerAliases(null, null));
        Assert.assertNull((Object)keyManager.chooseServerAlias(null, null, null));
        byte[] truststoreBytes = proxyCA.getChildTrustStore("password");
        KeyStore truststore = KeyStoreTestUtil.bytesToKeyStore((byte[])truststoreBytes, (String)"password");
        Assert.assertEquals((long)1L, (long)truststore.size());
        X509Certificate caCert = (X509Certificate)truststore.getCertificate("client");
        Assert.assertArrayEquals((Object[])new X509Certificate[]{caCert}, (Object[])keyManager.getCertificateChain(null));
        Assert.assertEquals((Object)proxyCA.getCaCert(), (Object)caCert);
        PrivateKey caPrivateKey = keyManager.getPrivateKey(null);
        PublicKey caPublicKey = caCert.getPublicKey();
        this.checkPrivatePublicKeys(caPrivateKey, caPublicKey);
        Assert.assertEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)caPublicKey);
        Assert.assertEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)caPrivateKey);
    }

    @Test
    public void testCreateHostnameVerifier() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenReturn((Object)KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "password"), (String)"password").getCertificateChain("server"));
        Assert.assertTrue((boolean)verifier.verify("foo", sslSession));
    }

    @Test
    public void testCreateHostnameVerifierSSLPeerUnverifiedException() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenThrow(new Throwable[]{new SSLPeerUnverifiedException("")});
        Assert.assertFalse((boolean)verifier.verify("foo", sslSession));
    }

    @Test
    public void testCreateHostnameVerifierWrongRM() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        ProxyCA proxyCA2 = new ProxyCA();
        proxyCA2.init();
        Mockito.when((Object)sslSession.getPeerCertificates()).thenReturn((Object)KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA2.createChildKeyStore(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "password"), (String)"password").getCertificateChain("server"));
        Assert.assertFalse((boolean)verifier.verify("foo", sslSession));
    }

    @Test
    public void testCreateHostnameVerifierExceptions() throws Exception {
        final ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        for (final Exception e : new Exception[]{new CertificateException(), new NoSuchAlgorithmException(), new InvalidKeyException(), new SignatureException(), new NoSuchProviderException()}) {
            SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
            Mockito.when((Object)sslSession.getPeerCertificates()).thenAnswer((Answer)new Answer<Certificate[]>(){

                public Certificate[] answer(InvocationOnMock invocation) throws Throwable {
                    Certificate cert;
                    Certificate[] certChain = KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "password"), (String)"password").getCertificateChain("server");
                    certChain[0] = cert = (Certificate)Mockito.spy((Object)certChain[0]);
                    ((Certificate)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)cert)).verify((PublicKey)Mockito.any());
                    return certChain;
                }
            });
            Assert.assertFalse((boolean)verifier.verify("foo", sslSession));
        }
    }

    @Test
    public void testCreateHostnameVerifierRealCert() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenAnswer((Answer)new Answer<Certificate[]>(){

            public Certificate[] answer(InvocationOnMock invocation) throws Throwable {
                Certificate[] certChain = new Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
                return certChain;
            }
        });
        Assert.assertTrue((boolean)verifier.verify("foo.com", sslSession));
    }

    @Test
    public void testCreateHostnameVerifierRealCertBad() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenAnswer((Answer)new Answer<Certificate[]>(){

            public Certificate[] answer(InvocationOnMock invocation) throws Throwable {
                Certificate[] certChain = new Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
                return certChain;
            }
        });
        Assert.assertFalse((boolean)verifier.verify("bar.com", sslSession));
    }

    private void checkCACert(X509Certificate caCert) {
        Assert.assertEquals((Object)caCert.getSubjectX500Principal().toString(), (Object)caCert.getIssuerDN().toString());
        Assert.assertEquals((Object)caCert.getSubjectX500Principal().toString(), (Object)caCert.getSubjectDN().toString());
        Assert.assertTrue((String)("Expected CA certificate X500 Principal to start with 'OU=YARN-', but did not: " + caCert.getSubjectX500Principal()), (boolean)caCert.getSubjectX500Principal().toString().startsWith("OU=YARN-"));
        Assert.assertFalse((String)("Found multiple fields in X500 Principal, when there should have only been one: " + caCert.getSubjectX500Principal()), (boolean)caCert.getSubjectX500Principal().toString().contains(","));
        Assert.assertEquals((Object)"SHA512withRSA", (Object)caCert.getSigAlgName());
        Assert.assertEquals((Object)new GregorianCalendar(2037, 11, 31).getTime(), (Object)caCert.getNotAfter());
        Assert.assertTrue((String)("Expected certificate to have started but was not: " + caCert.getNotBefore()), (boolean)caCert.getNotBefore().before(new Date()));
        Assert.assertEquals((long)0L, (long)caCert.getBasicConstraints());
    }

    private void checkPrivatePublicKeys(PrivateKey privateKey, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] data = new byte[2000];
        new Random().nextBytes(data);
        Signature signer = Signature.getInstance("SHA512withRSA");
        signer.initSign(privateKey);
        signer.update(data);
        byte[] sig = signer.sign();
        signer = Signature.getInstance("SHA512withRSA");
        signer.initVerify(publicKey);
        signer.update(data);
        Assert.assertTrue((boolean)signer.verify(sig));
    }

    private X509Certificate[] castCertificateArrayToX509CertificateArray(Certificate[] certs) {
        return (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
    }

    private CertKeyPair createCertAndKeyPair() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        return new CertKeyPair(proxyCA.getCaCert(), proxyCA.getCaKeyPair());
    }

    private static class CertKeyPair {
        private X509Certificate cert;
        private KeyPair keyPair;

        public CertKeyPair(X509Certificate cert, KeyPair keyPair) {
            this.cert = cert;
            this.keyPair = keyPair;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }
    }
}

