/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServerForTest;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebAppProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestWebAppProxyServlet.class);
    private static Server server;
    private static int originalPort;
    Configuration configuration = new Configuration();

    @BeforeClass
    public static void start() throws Exception {
        server = new Server(0);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(20);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(TestServlet.class), "/bar");
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        originalPort = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        LOG.info("Running embedded servlet container at: http://localhost:" + originalPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWebAppProxyServlet() throws Exception {
        this.configuration.set("yarn.web-proxy.address", "localhost:9090");
        this.configuration.setInt("hadoop.http.max.threads", 10);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest(originalPort);
        proxy.init(this.configuration);
        proxy.start();
        int proxyPort = proxy.getProxyPort();
        WebAppProxyServerForTest.AppReportFetcherForTest appReportFetcher = proxy.getAppReportFetcher();
        try {
            URL emptyUrl = new URL("http://localhost:" + proxyPort + "/proxy");
            HttpURLConnection emptyProxyConn = (HttpURLConnection)emptyUrl.openConnection();
            emptyProxyConn.connect();
            Assert.assertEquals((long)404L, (long)emptyProxyConn.getResponseCode());
            URL wrongUrl = new URL("http://localhost:" + proxyPort + "/proxy/app");
            HttpURLConnection proxyConn = (HttpURLConnection)wrongUrl.openConnection();
            proxyConn.connect();
            Assert.assertEquals((long)500L, (long)proxyConn.getResponseCode());
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0");
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            Assert.assertTrue((boolean)WebAppProxyServerForTest.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            URL redirectUrl = new URL("http://localhost:" + proxyPort + "/proxy/redirect/application_00_0");
            proxyConn = (HttpURLConnection)redirectUrl.openConnection();
            proxyConn.setInstanceFollowRedirects(false);
            proxyConn.connect();
            Assert.assertEquals((String)"The proxy returned an unexpected status code rather thanredirecting the connection (302)", (long)302L, (long)proxyConn.getResponseCode());
            String expected = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.configuration) + "/cluster/failure/application_00_0";
            String redirect = proxyConn.getHeaderField("Location");
            Assert.assertEquals((String)"The proxy did not redirect the connection to the failure page of the RM", (Object)expected, (Object)redirect);
            appReportFetcher.setAnswer(1);
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)404L, (long)proxyConn.getResponseCode());
            Assert.assertFalse((boolean)WebAppProxyServerForTest.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.setAnswer(4);
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)404L, (long)proxyConn.getResponseCode());
            Assert.assertFalse((boolean)WebAppProxyServerForTest.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
            appReportFetcher.setAnswer(2);
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            String s = this.readInputStream(proxyConn.getInputStream());
            Assert.assertTrue((boolean)s.contains("to continue to an Application Master web interface owned by"));
            Assert.assertTrue((boolean)s.contains("WARNING: The following page may not be safe!"));
            appReportFetcher.setAnswer(3);
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            appReportFetcher.setAnswer(5);
            URL clientUrl = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0/test/tez?x=y&h=p");
            proxyConn = (HttpURLConnection)clientUrl.openConnection();
            proxyConn.connect();
            LOG.info("" + proxyConn.getURL());
            LOG.info("ProxyConn.getHeaderField(): " + proxyConn.getHeaderField("Location"));
            Assert.assertEquals((Object)("http://localhost:" + originalPort + "/foo/bar/test/tez?a=b&x=y&h=p#main"), (Object)proxyConn.getURL().toString());
        }
        finally {
            proxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testAppReportForEmptyTrackingUrl() throws Exception {
        this.configuration.set("yarn.web-proxy.address", "localhost:9090");
        this.configuration.setInt("hadoop.http.max.threads", 10);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest(originalPort);
        proxy.init(this.configuration);
        proxy.start();
        int proxyPort = proxy.getProxyPort();
        WebAppProxyServerForTest.AppReportFetcherForTest appReportFetcher = proxy.getAppReportFetcher();
        try {
            this.configuration.setBoolean("yarn.timeline-service.generic-application-history.enabled", false);
            ApplicationId app = ApplicationId.newInstance((long)0L, (int)0);
            appReportFetcher.setAnswer(6);
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/" + app.toString());
            HttpURLConnection proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            try {
                proxyConn.getResponseCode();
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            String appAddressInRm = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.configuration) + "/cluster/app/" + app.toString();
            Assert.assertTrue((String)"Webapp proxy servlet should have redirected to RM", (boolean)proxyConn.getURL().toString().equals(appAddressInRm));
            this.configuration.setBoolean("yarn.timeline-service.generic-application-history.enabled", true);
            proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.connect();
            try {
                proxyConn.getResponseCode();
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            String appAddressInAhs = WebAppUtils.getHttpSchemePrefix((Configuration)this.configuration) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)this.configuration) + "/applicationhistory/app/" + app.toString();
            Assert.assertTrue((String)"Webapp proxy servlet should have redirected to AHS", (boolean)proxyConn.getURL().toString().equals(appAddressInAhs));
        }
        finally {
            proxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWebAppProxyServerMainMethod() throws Exception {
        WebAppProxyServer mainServer = null;
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.web-proxy.address", "localhost:9099");
        try {
            mainServer = WebAppProxyServer.startServer((Configuration)conf);
            int counter = 20;
            URL wrongUrl = new URL("http://localhost:9099/proxy/app");
            HttpURLConnection proxyConn = null;
            while (counter > 0) {
                --counter;
                try {
                    proxyConn = (HttpURLConnection)wrongUrl.openConnection();
                    proxyConn.connect();
                    proxyConn.getResponseCode();
                    counter = 0;
                }
                catch (Exception e) {
                    Thread.sleep(100L);
                }
            }
            Assert.assertNotNull(proxyConn);
            Assert.assertEquals((long)500L, (long)proxyConn.getResponseCode());
        }
        finally {
            if (mainServer != null) {
                mainServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWebAppProxyServerHeaderInjection() throws Exception {
        WebAppProxyServer mainServer = null;
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.web-proxy.address", "localhost:9099");
        try {
            mainServer = WebAppProxyServer.startServer((Configuration)conf);
            int counter = 20;
            URL wrongUrl = new URL("http://localhost:9099/proxy/%C4%8D%C4%8ASomeCustomInjectedHeader:%20injected_headerVal_1484290871375_0113/");
            HttpURLConnection proxyConn = null;
            while (counter > 0) {
                --counter;
                try {
                    proxyConn = (HttpURLConnection)wrongUrl.openConnection();
                    proxyConn.connect();
                    proxyConn.getResponseCode();
                    counter = 0;
                }
                catch (Exception e) {
                    Thread.sleep(100L);
                }
            }
            Assert.assertNotNull(proxyConn);
            Assert.assertEquals((long)500L, (long)proxyConn.getResponseCode());
            Assert.assertTrue((String)"Header injection happened", (proxyConn.getHeaderField("SomeCustomInjectedHeader") == null ? 1 : 0) != 0);
        }
        finally {
            if (mainServer != null) {
                mainServer.stop();
            }
        }
    }

    private String readInputStream(InputStream input) throws Exception {
        int read;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((read = input.read(buffer)) >= 0) {
            data.write(buffer, 0, read);
        }
        return new String(data.toByteArray(), "UTF-8");
    }

    @AfterClass
    public static void stop() throws Exception {
        try {
            server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        originalPort = 0;
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ServletInputStream is = req.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            int c = is.read();
            while (c > -1) {
                os.write(c);
                c = is.read();
            }
            is.close();
            os.close();
            resp.setStatus(200);
        }
    }
}

