/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWebAppProxyServer {
    private WebAppProxyServer webAppProxy = null;
    private final String proxyAddress = "0.0.0.0:8888";

    @Before
    public void setUp() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.web-proxy.address", "0.0.0.0:8888");
        this.webAppProxy = new WebAppProxyServer();
        this.webAppProxy.init((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        this.webAppProxy.stop();
    }

    @Test
    public void testStart() {
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)this.webAppProxy.getServiceState());
        this.webAppProxy.start();
        for (Service service : this.webAppProxy.getServices()) {
            if (!(service instanceof WebAppProxy)) continue;
            Assert.assertEquals((Object)((WebAppProxy)service).getBindAddress(), (Object)"0.0.0.0:8888");
        }
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.webAppProxy.getServiceState());
    }

    @Test
    public void testBindAddress() {
        YarnConfiguration conf = new YarnConfiguration();
        InetSocketAddress defaultBindAddress = WebAppProxyServer.getBindAddress((Configuration)conf);
        Assert.assertEquals((String)"Web Proxy default bind address port is incorrect", (long)9099L, (long)defaultBindAddress.getPort());
    }
}

