/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestPerNodeTimelineCollectorsAuxService {
    private ApplicationAttemptId appAttemptId;
    private PerNodeTimelineCollectorsAuxService auxService;
    private Configuration conf;
    private ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);

    public TestPerNodeTimelineCollectorsAuxService() {
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        this.conf.setFloat("yarn.timeline-service.version", 2.0f);
        this.conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        this.conf.setLong("yarn.timeline-service.app-collector.linger-period.ms", 1000L);
    }

    @AfterEach
    public void tearDown() throws Shell.ExitCodeException {
        if (this.auxService != null) {
            this.auxService.stop();
        }
    }

    @Test
    void testAddApplication() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        this.auxService.close();
    }

    @Test
    void testAddApplicationNonAMContainer() throws Exception {
        this.auxService = this.createCollector();
        ContainerId containerId = this.getContainerId(2L);
        ContainerInitializationContext context = (ContainerInitializationContext)Mockito.mock(ContainerInitializationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        this.auxService.initializeContainer(context);
        Assertions.assertFalse((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
    }

    @Test
    void testRemoveApplication() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        ContainerId containerId = this.getAMContainerId();
        ContainerTerminationContext context = (ContainerTerminationContext)Mockito.mock(ContainerTerminationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)context.getContainerType()).thenReturn((Object)ContainerType.APPLICATION_MASTER);
        this.auxService.stopContainer(context);
        Assertions.assertFalse((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        this.auxService.close();
    }

    @Test
    void testRemoveApplicationNonAMContainer() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        ContainerId containerId = this.getContainerId(2L);
        ContainerTerminationContext context = (ContainerTerminationContext)Mockito.mock(ContainerTerminationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        this.auxService.stopContainer(context);
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        this.auxService.close();
    }

    @Test
    @Timeout(value=60000L)
    void testLaunch() throws Exception {
        ExitUtil.disableSystemExit();
        try {
            this.auxService = PerNodeTimelineCollectorsAuxService.launchServer((String[])new String[0], (NodeTimelineCollectorManager)this.createCollectorManager(), (Configuration)this.conf);
        }
        catch (ExitUtil.ExitException e) {
            Assertions.assertEquals((int)0, (int)e.status);
            ExitUtil.resetFirstExitException();
            Assertions.fail();
        }
    }

    private PerNodeTimelineCollectorsAuxService createCollectorAndAddApplication() {
        PerNodeTimelineCollectorsAuxService service = this.createCollector();
        ContainerInitializationContext context = this.createContainerInitalizationContext(1);
        service.initializeContainer(context);
        return service;
    }

    ContainerInitializationContext createContainerInitalizationContext(int attempt) {
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)attempt);
        ContainerId containerId = this.getAMContainerId();
        ContainerInitializationContext context = (ContainerInitializationContext)Mockito.mock(ContainerInitializationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)context.getContainerType()).thenReturn((Object)ContainerType.APPLICATION_MASTER);
        return context;
    }

    ContainerTerminationContext createContainerTerminationContext(int attempt) {
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)attempt);
        ContainerId containerId = this.getAMContainerId();
        ContainerTerminationContext context = (ContainerTerminationContext)Mockito.mock(ContainerTerminationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)context.getContainerType()).thenReturn((Object)ContainerType.APPLICATION_MASTER);
        return context;
    }

    private PerNodeTimelineCollectorsAuxService createCollector() {
        NodeTimelineCollectorManager collectorManager = this.createCollectorManager();
        PerNodeTimelineCollectorsAuxService service = (PerNodeTimelineCollectorsAuxService)Mockito.spy((Object)new PerNodeTimelineCollectorsAuxService(collectorManager){

            protected Future removeApplicationCollector(ContainerId containerId) {
                Future future = super.removeApplicationCollector(containerId);
                try {
                    future.get();
                }
                catch (Exception e) {
                    Assertions.fail((String)"Expeption thrown while removing collector");
                }
                return future;
            }
        });
        service.init(this.conf);
        service.start();
        return service;
    }

    private NodeTimelineCollectorManager createCollectorManager() {
        NodeTimelineCollectorManager collectorManager = (NodeTimelineCollectorManager)Mockito.spy((Object)new NodeTimelineCollectorManager());
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)new Configuration()).when((Object)collectorManager)).getConfig();
        CollectorNodemanagerProtocol nmCollectorService = (CollectorNodemanagerProtocol)Mockito.mock(CollectorNodemanagerProtocol.class);
        GetTimelineCollectorContextResponse response = GetTimelineCollectorContextResponse.newInstance(null, null, null, (long)0L);
        try {
            Mockito.when((Object)nmCollectorService.getTimelineCollectorContext((GetTimelineCollectorContextRequest)ArgumentMatchers.any(GetTimelineCollectorContextRequest.class))).thenReturn((Object)response);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)nmCollectorService).when((Object)collectorManager)).getNMCollectorService();
        return collectorManager;
    }

    private ContainerId getAMContainerId() {
        return this.getContainerId(1L);
    }

    private ContainerId getContainerId(long id) {
        return ContainerId.newContainerId((ApplicationAttemptId)this.appAttemptId, (long)id);
    }

    @Test
    @Timeout(value=60000L)
    void testRemoveAppWhenSecondAttemptAMCotainerIsLaunchedSameNode() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        ContainerInitializationContext containerInitalizationContext = this.createContainerInitalizationContext(2);
        this.auxService.initializeContainer(containerInitalizationContext);
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()), (String)"Applicatin not found in collectors.");
        ContainerTerminationContext context = this.createContainerTerminationContext(1);
        this.auxService.stopContainer(context);
        Assertions.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()), (String)"collector has removed application though 2nd attempt is running this node");
        context = this.createContainerTerminationContext(2);
        this.auxService.stopContainer(context);
        Assertions.assertFalse((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()), (String)"Application is not removed from collector");
        this.auxService.close();
    }
}

