/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.List;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimelineReaderUtils {
    @Test
    void testSplitUsingEscapeAndDelimChar() throws Exception {
        List list = TimelineReaderUtils.split((String)"*!cluster!*!b**o***!xer!oozie**", (char)'!', (char)'*');
        Object[] arr = new String[list.size()];
        arr = list.toArray(arr);
        Assertions.assertArrayEquals((Object[])new String[]{"!cluster", "!b*o*!xer", "oozie*"}, (Object[])arr);
        list = TimelineReaderUtils.split((String)"*!cluster!*!b**o***!xer!!", (char)'!', (char)'*');
        arr = new String[list.size()];
        arr = (String[])list.toArray(arr);
        Assertions.assertArrayEquals((Object[])new String[]{"!cluster", "!b*o*!xer", "", ""}, (Object[])arr);
    }

    @Test
    void testJoinAndEscapeStrings() throws Exception {
        Assertions.assertEquals((Object)"*!cluster!*!b**o***!xer!oozie**", (Object)TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{"!cluster", "!b*o*!xer", "oozie*"}, (char)'!', (char)'*'));
        Assertions.assertEquals((Object)"*!cluster!*!b**o***!xer!!", (Object)TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{"!cluster", "!b*o*!xer", "", ""}, (char)'!', (char)'*'));
        Assertions.assertNull((Object)TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{"!cluster", "!b*o*!xer", null, ""}, (char)'!', (char)'*'));
    }
}

