/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.AnswersWithDelay;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTimelineCollector {
    private TimelineEntities generateTestEntities(int groups, int entities) {
        TimelineEntities te = new TimelineEntities();
        for (int j = 0; j < groups; ++j) {
            for (int i = 0; i < entities; ++i) {
                TimelineEntity entity = new TimelineEntity();
                String containerId = "container_1000178881110_2002_" + i;
                entity.setId(containerId);
                String entityType = "TEST_" + j;
                entity.setType(entityType);
                long cTime = 1425016501000L;
                entity.setCreatedTime(Long.valueOf(cTime));
                HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
                TimelineMetric m1 = new TimelineMetric();
                m1.setId("HDFS_BYTES_WRITE");
                m1.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
                long ts = System.currentTimeMillis();
                m1.addValue(ts - 20000L, (Number)100L);
                metrics.add(m1);
                TimelineMetric m2 = new TimelineMetric();
                m2.setId("VCORES_USED");
                m2.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
                m2.addValue(ts - 20000L, (Number)3L);
                metrics.add(m2);
                TimelineMetric m3 = new TimelineMetric();
                m3.setId("UNRELATED_VALUES");
                m3.addValue(ts - 20000L, (Number)3L);
                metrics.add(m3);
                TimelineMetric m4 = new TimelineMetric();
                m4.setId("TXN_FINISH_TIME");
                m4.setRealtimeAggregationOp(TimelineMetricOperation.MAX);
                m4.addValue(ts - 20000L, (Number)i);
                metrics.add(m4);
                entity.addMetrics(metrics);
                te.addEntity(entity);
            }
        }
        return te;
    }

    @Test
    void testAggregation() throws Exception {
        int groups = 3;
        int n = 50;
        TimelineEntities testEntities = this.generateTestEntities(groups, n);
        TimelineEntity resultEntity = TimelineCollector.aggregateEntities((TimelineEntities)testEntities, (String)"test_result", (String)"TEST_AGGR", (boolean)true);
        Assertions.assertThat((Iterable)resultEntity.getMetrics()).hasSize(groups * 3);
        for (int i = 0; i < groups; ++i) {
            Set metrics = resultEntity.getMetrics();
            for (TimelineMetric m : metrics) {
                if (m.getId().startsWith("HDFS_BYTES_WRITE")) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)(100 * n), (int)m.getSingleDataValue().intValue());
                    continue;
                }
                if (m.getId().startsWith("VCORES_USED")) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)(3 * n), (int)m.getSingleDataValue().intValue());
                    continue;
                }
                if (m.getId().startsWith("TXN_FINISH_TIME")) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)(n - 1), (Object)m.getSingleDataValue());
                    continue;
                }
                org.junit.jupiter.api.Assertions.fail((String)("Unrecognized metric! " + m.getId()));
            }
        }
        TimelineEntities testEntities1 = this.generateTestEntities(1, n);
        TimelineEntity resultEntity1 = TimelineCollector.aggregateEntities((TimelineEntities)testEntities1, (String)"test_result", (String)"TEST_AGGR", (boolean)false);
        Assertions.assertThat((Iterable)resultEntity1.getMetrics()).hasSize(3);
        Set metrics = resultEntity1.getMetrics();
        for (TimelineMetric m : metrics) {
            if (m.getId().equals("HDFS_BYTES_WRITE")) {
                org.junit.jupiter.api.Assertions.assertEquals((int)(100 * n), (int)m.getSingleDataValue().intValue());
                continue;
            }
            if (m.getId().equals("VCORES_USED")) {
                org.junit.jupiter.api.Assertions.assertEquals((int)(3 * n), (int)m.getSingleDataValue().intValue());
                continue;
            }
            if (m.getId().equals("TXN_FINISH_TIME")) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)(n - 1), (Object)m.getSingleDataValue());
                continue;
            }
            org.junit.jupiter.api.Assertions.fail((String)("Unrecognized metric! " + m.getId()));
        }
    }

    @Test
    void testPutEntity() throws IOException {
        TimelineWriter writer = (TimelineWriter)Mockito.mock(TimelineWriter.class);
        TimelineHealth timelineHealth = new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "");
        Mockito.when((Object)writer.getHealthStatus()).thenReturn((Object)timelineHealth);
        Configuration conf = new Configuration();
        conf.setInt("yarn.timeline-service.client.max-retries", 5);
        conf.setLong("yarn.timeline-service.client.retry-interval-ms", 500L);
        TimelineCollectorForTest collector = new TimelineCollectorForTest(writer);
        collector.init(conf);
        TimelineEntities entities = this.generateTestEntities(1, 1);
        collector.putEntities(entities, UserGroupInformation.createRemoteUser((String)"test-user"));
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)1))).write((TimelineCollectorContext)ArgumentMatchers.any(TimelineCollectorContext.class), (TimelineEntities)ArgumentMatchers.any(TimelineEntities.class), (UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class));
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    void testPutEntityWithStorageDown() throws IOException {
        boolean exceptionCaught;
        block2: {
            TimelineWriter writer = (TimelineWriter)Mockito.mock(TimelineWriter.class);
            TimelineHealth timelineHealth = new TimelineHealth(TimelineHealth.TimelineHealthStatus.CONNECTION_FAILURE, "");
            Mockito.when((Object)writer.getHealthStatus()).thenReturn((Object)timelineHealth);
            Configuration conf = new Configuration();
            conf.setInt("yarn.timeline-service.client.max-retries", 5);
            conf.setLong("yarn.timeline-service.client.retry-interval-ms", 500L);
            TimelineCollectorForTest collector = new TimelineCollectorForTest(writer);
            collector.init(conf);
            TimelineEntities entities = this.generateTestEntities(1, 1);
            exceptionCaught = false;
            try {
                collector.putEntities(entities, UserGroupInformation.createRemoteUser((String)"test-user"));
            }
            catch (Exception e) {
                if (!e.getMessage().contains("Failed to putEntities")) break block2;
                exceptionCaught = true;
            }
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionCaught, (String)"TimelineCollector putEntity failed to handle storage down");
    }

    @Test
    void testPutEntityAsync() throws Exception {
        TimelineWriter writer = (TimelineWriter)Mockito.mock(TimelineWriter.class);
        TimelineCollectorForTest collector = new TimelineCollectorForTest(writer);
        collector.init(new Configuration());
        collector.start();
        TimelineEntities entities = this.generateTestEntities(1, 1);
        collector.putEntitiesAsync(entities, UserGroupInformation.createRemoteUser((String)"test-user"));
        Thread.sleep(1000L);
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)1))).write((TimelineCollectorContext)ArgumentMatchers.any(TimelineCollectorContext.class), (TimelineEntities)ArgumentMatchers.any(TimelineEntities.class), (UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class));
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.never())).flush();
        collector.stop();
    }

    @Test
    void testAsyncEntityDiscard() throws Exception {
        TimelineWriter writer = (TimelineWriter)Mockito.mock(TimelineWriter.class);
        Mockito.when((Object)writer.write((TimelineCollectorContext)ArgumentMatchers.any(), (TimelineEntities)ArgumentMatchers.any(), (UserGroupInformation)ArgumentMatchers.any())).thenAnswer((Answer)new AnswersWithDelay(500L, (Answer)new Returns((Object)new TimelineWriteResponse())));
        TimelineCollectorForTest collector = new TimelineCollectorForTest(writer);
        Configuration config = new Configuration();
        config.setInt("yarn.timeline-service.writer.async.queue.capacity", 3);
        collector.init(config);
        collector.start();
        for (int i = 0; i < 10; ++i) {
            TimelineEntities entities = this.generateTestEntities(i + 1, 1);
            collector.putEntitiesAsync(entities, UserGroupInformation.createRemoteUser((String)"test-user"));
        }
        Thread.sleep(3000L);
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)4))).write((TimelineCollectorContext)ArgumentMatchers.any(TimelineCollectorContext.class), (TimelineEntities)ArgumentMatchers.any(TimelineEntities.class), (UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class));
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.never())).flush();
        collector.stop();
    }

    @Test
    void testPutDomain() throws IOException {
        TimelineWriter writer = (TimelineWriter)Mockito.mock(TimelineWriter.class);
        TimelineHealth timelineHealth = new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "");
        Mockito.when((Object)writer.getHealthStatus()).thenReturn((Object)timelineHealth);
        Configuration conf = new Configuration();
        conf.setInt("yarn.timeline-service.client.max-retries", 5);
        conf.setLong("yarn.timeline-service.client.retry-interval-ms", 500L);
        TimelineCollectorForTest collector = new TimelineCollectorForTest(writer);
        collector.init(conf);
        TimelineDomain domain = TestTimelineCollector.generateDomain("id", "desc", "owner", "reader1,reader2", "writer", 0L, 1L);
        collector.putDomain(domain, UserGroupInformation.createRemoteUser((String)"owner"));
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)1))).write((TimelineCollectorContext)ArgumentMatchers.any(TimelineCollectorContext.class), (TimelineDomain)ArgumentMatchers.any(TimelineDomain.class));
        ((TimelineWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)1))).flush();
    }

    private static TimelineDomain generateDomain(String id, String desc, String owner, String reader, String writer, Long cTime, Long mTime) {
        TimelineDomain domain = new TimelineDomain();
        domain.setId(id);
        domain.setDescription(desc);
        domain.setOwner(owner);
        domain.setReaders(reader);
        domain.setWriters(writer);
        domain.setCreatedTime(cTime);
        domain.setModifiedTime(mTime);
        return domain;
    }

    private static TimelineEntity createEntity(String id, String type) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType(type);
        return entity;
    }

    private static TimelineMetric createDummyMetric(long ts, Long value) {
        TimelineMetric metric = new TimelineMetric();
        metric.setId("dummy_metric");
        metric.addValue(ts, (Number)value);
        metric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
        return metric;
    }

    @Test
    void testClearPreviousEntitiesOnAggregation() throws Exception {
        final long ts = System.currentTimeMillis();
        TimelineCollector collector = new TimelineCollector(""){

            public TimelineCollectorContext getTimelineEntityContext() {
                return new TimelineCollectorContext("cluster", "user", "flow", "1", Long.valueOf(1L), ApplicationId.newInstance((long)ts, (int)1).toString());
            }
        };
        TimelineWriter writer = (TimelineWriter)Mockito.mock(TimelineWriter.class);
        TimelineHealth timelineHealth = new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "");
        Mockito.when((Object)writer.getHealthStatus()).thenReturn((Object)timelineHealth);
        Configuration conf = new Configuration();
        conf.setInt("yarn.timeline-service.client.max-retries", 5);
        conf.setLong("yarn.timeline-service.client.retry-interval-ms", 500L);
        collector.init(conf);
        collector.setWriter(writer);
        TimelineEntities entities = new TimelineEntities();
        for (int i = 1; i <= 5; ++i) {
            TimelineEntity entity = TestTimelineCollector.createEntity("e" + i, "type");
            entity.addMetric(TestTimelineCollector.createDummyMetric(ts + (long)i, Long.valueOf(i * 50)));
            entities.addEntity(entity);
        }
        collector.putEntities(entities, UserGroupInformation.getCurrentUser());
        TimelineCollectorContext currContext = collector.getTimelineEntityContext();
        Map aggregationGroups = collector.getAggregationGroups();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"type"}), aggregationGroups.keySet());
        TimelineEntity aggregatedEntity = TimelineCollector.aggregateWithoutGroupId((Map)aggregationGroups, (String)currContext.getAppId(), (String)TimelineEntityType.YARN_APPLICATION.toString());
        TimelineMetric aggregatedMetric = (TimelineMetric)aggregatedEntity.getMetrics().iterator().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)750L, aggregatedMetric.getValues().values().iterator().next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TimelineMetricOperation.SUM, (Object)aggregatedMetric.getRealtimeAggregationOp());
        aggregatedEntity = TimelineCollector.aggregateWithoutGroupId((Map)aggregationGroups, (String)currContext.getAppId(), (String)TimelineEntityType.YARN_APPLICATION.toString());
        aggregatedMetric = (TimelineMetric)aggregatedEntity.getMetrics().iterator().next();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)aggregatedMetric.getValues().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TimelineMetricOperation.NOP, (Object)aggregatedMetric.getRealtimeAggregationOp());
        entities = new TimelineEntities();
        for (int i = 1; i <= 3; ++i) {
            TimelineEntity entity = TestTimelineCollector.createEntity("e" + i, "type");
            entity.addMetric(TestTimelineCollector.createDummyMetric(System.currentTimeMillis() + (long)i, 50L));
            entities.addEntity(entity);
        }
        aggregationGroups = collector.getAggregationGroups();
        collector.putEntities(entities, UserGroupInformation.getCurrentUser());
        aggregatedEntity = TimelineCollector.aggregateWithoutGroupId((Map)aggregationGroups, (String)currContext.getAppId(), (String)TimelineEntityType.YARN_APPLICATION.toString());
        aggregatedMetric = (TimelineMetric)aggregatedEntity.getMetrics().iterator().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)150L, aggregatedMetric.getValues().values().iterator().next());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TimelineMetricOperation.SUM, (Object)aggregatedMetric.getRealtimeAggregationOp());
        collector.close();
    }

    private static class TimelineCollectorForTest
    extends TimelineCollector {
        private final TimelineCollectorContext context = new TimelineCollectorContext();

        TimelineCollectorForTest(TimelineWriter writer) {
            super("TimelineCollectorForTest");
            this.setWriter(writer);
        }

        public TimelineCollectorContext getTimelineEntityContext() {
            return this.context;
        }
    }
}

